/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.jetbrains.cidr.CidrNativeLibraryPaths;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjCHelper {
    private static final AtomicLong nextCallbackId = new AtomicLong();

    public static native Pointer cancel_callback(long var0);

    public static native Pointer create_block(long var0, MyCallback var2);

    public static native Pointer create_block_bool(long var0, MyBoolCallback var2);

    public static native Pointer create_block_long(long var0, MyLongCallback var2);

    public static native Pointer create_id_block(long var0, MyIDCallback var2);

    public static native Pointer create_id_block2(long var0, MyIDCallback2 var2);

    public static native Pointer create_id_block3(long var0, MyIDCallback3 var2);

    public static native Pointer create_block2(long var0, MyCallback2 var2);

    @Nullable
    public static ID pointerToID(@Nullable Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        return new ID(new PointerByReference(ptr).getPointer().getLong(0L));
    }

    @NotNull
    public static ID performWithCallback(long id, Callback callback, @NotNull Function<Pointer, ID> action) {
        Pointer block = null;
        if (callback instanceof MyCallback) {
            block = ObjCHelper.create_block(id, (MyCallback)callback);
        } else if (callback instanceof MyIDCallback) {
            block = ObjCHelper.create_id_block(id, (MyIDCallback)callback);
        } else if (callback instanceof MyIDCallback2) {
            block = ObjCHelper.create_id_block2(id, (MyIDCallback2)callback);
        } else if (callback instanceof MyIDCallback3) {
            block = ObjCHelper.create_id_block3(id, (MyIDCallback3)callback);
        } else if (callback instanceof MyCallback2) {
            block = ObjCHelper.create_block2(id, (MyCallback2)callback);
        } else if (callback instanceof MyBoolCallback) {
            block = ObjCHelper.create_block_bool(id, (MyBoolCallback)callback);
        } else if (callback instanceof MyLongCallback) {
            block = ObjCHelper.create_block_long(id, (MyLongCallback)callback);
        }
        ID ret = action.apply(block);
        Foundation.invoke((ID)ObjCHelper.pointerToID(block), (String)"release", (Object[])new Object[0]);
        return ret;
    }

    public static long getNextCallbackID() {
        return nextCallbackId.getAndIncrement();
    }

    static {
        Native.register(ObjCHelper.class, (String)CidrNativeLibraryPaths.libObjCHelper.getPath());
    }

    public static interface MyCallback2
    extends Callback {
        public void invoke(Pointer var1, @Nullable Pointer var2);
    }

    public static interface MyIDCallback3
    extends Callback {
        public void invoke(ID var1, ID var2, ID var3);
    }

    public static interface MyIDCallback2
    extends Callback {
        public void invoke(ID var1, ID var2);
    }

    public static interface MyIDCallback
    extends Callback {
        public void invoke(ID var1);
    }

    public static interface MyLongCallback
    extends Callback {
        public void invoke(long var1);
    }

    public static interface MyBoolCallback
    extends Callback {
        public void invoke(boolean var1);
    }

    public static interface MyCallback
    extends Callback {
        public void invoke(Pointer var1);
    }
}

