/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomExtensionsRegistrarImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomExtenderEP
implements PluginAware {
    @ApiStatus.Internal
    public static final ExtensionPointName<DomExtenderEP> EP_NAME = new ExtensionPointName("com.intellij.dom.extender");
    private static final Logger LOG = Logger.getInstance(DomExtenderEP.class);
    private PluginDescriptor pluginDescriptor;
    @RequiredElement
    @Attribute(value="domClass")
    public String domClassName;
    @RequiredElement
    @Attribute(value="extenderClass")
    public String extenderClassName;
    private volatile Class<?> myDomClass;
    private volatile DomExtender<?> myExtender;

    private DomExtenderEP() {
    }

    public DomExtenderEP(@NotNull String domClassName, @NotNull PluginDescriptor pluginDescriptor) {
        this.domClassName = domClassName;
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public DomExtensionsRegistrarImpl extend(@NotNull Project project2, @NotNull DomInvocationHandler handler, @Nullable DomExtensionsRegistrarImpl registrar) {
        if (this.myDomClass == null) {
            try {
                this.myDomClass = Class.forName(this.domClassName, true, this.pluginDescriptor.getPluginClassLoader());
            }
            catch (Throwable e) {
                LOG.error((Throwable)new PluginException(e, this.pluginDescriptor.getPluginId()));
                return registrar;
            }
        }
        if (!this.myDomClass.isAssignableFrom(handler.getRawType())) {
            return registrar;
        }
        if (this.myExtender == null) {
            try {
                this.myExtender = (DomExtender)project2.instantiateExtensionWithPicoContainerOnlyIfNeeded(this.extenderClassName, this.pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
                return registrar;
            }
        }
        if (!this.myExtender.supportsStubs() && XmlUtil.isStubBuilding()) {
            return registrar;
        }
        if (registrar == null) {
            registrar = new DomExtensionsRegistrarImpl();
        }
        this.myExtender.registerExtensions(handler.getProxy(), (DomExtensionsRegistrar)registrar);
        return registrar;
    }

    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }
}

