/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.gotosymbol;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToSymbolProvider
implements ChooseByNameContributor {
    private final Key<CachedValue<Collection<Module>>> ACCEPTABLE_MODULES = Key.create((String)("ACCEPTABLE_MODULES_" + this.toString()));

    protected abstract void addNames(@NotNull Module var1, Set<String> var2);

    protected abstract void addItems(@NotNull Module var1, String var2, List<NavigationItem> var3);

    protected abstract boolean acceptModule(Module var1);

    protected static void addNewNames(@NotNull List<? extends DomElement> elements, Set<? super String> existingNames) {
        for (DomElement domElement : elements) {
            existingNames.add(domElement.getGenericInfo().getElementName(domElement));
        }
    }

    private Collection<Module> getAcceptableModules(Project project2) {
        return (Collection)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, this.ACCEPTABLE_MODULES, () -> CachedValueProvider.Result.create(this.calcAcceptableModules(project2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @NotNull
    protected Collection<Module> calcAcceptableModules(@NotNull Project project2) {
        return ContainerUtil.findAll((Object[])ModuleManager.getInstance((Project)project2).getModules(), module2 -> this.acceptModule((Module)module2));
    }

    public String @NotNull [] getNames(Project project2, boolean includeNonProjectItems) {
        HashSet<String> result2 = new HashSet<String>();
        for (Module module2 : this.getAcceptableModules(project2)) {
            this.addNames(module2, result2);
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    public NavigationItem @NotNull [] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        ArrayList<NavigationItem> result2 = new ArrayList<NavigationItem>();
        for (Module module2 : this.getAcceptableModules(project2)) {
            this.addItems(module2, name, result2);
        }
        return result2.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
    }

    @Nullable
    protected static NavigationItem createNavigationItem(DomElement domElement) {
        GenericDomValue name = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (name != null);
        XmlElement psiElement = name.getXmlElement();
        String value = name.getStringValue();
        if (psiElement == null || value == null) {
            return null;
        }
        Icon icon = ElementPresentationManager.getIcon((Object)domElement);
        return GoToSymbolProvider.createNavigationItem((PsiElement)psiElement, value, icon);
    }

    @NotNull
    protected static NavigationItem createNavigationItem(@NotNull PsiElement element, @NotNull @NonNls String text, @Nullable Icon icon) {
        return new BaseNavigationItem(element, text, icon);
    }

    public static class BaseNavigationItem
    extends FakePsiElement {
        private final PsiElement myPsiElement;
        private final String myText;
        private final Icon myIcon;

        public BaseNavigationItem(@NotNull PsiElement psiElement, @NotNull @NonNls String text, @Nullable Icon icon) {
            this.myPsiElement = psiElement;
            this.myText = text;
            this.myIcon = icon;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.myPsiElement;
        }

        public Icon getIcon(boolean flags) {
            return this.myIcon;
        }

        public String getName() {
            return this.myText;
        }

        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                public String getPresentableText() {
                    return myText;
                }

                public String getLocationString() {
                    return '(' + myPsiElement.getContainingFile().getName() + ')';
                }

                @Nullable
                public Icon getIcon(boolean open) {
                    return myIcon;
                }
            };
        }

        public PsiElement getParent() {
            return this.myPsiElement.getParent();
        }

        @NotNull
        public Project getProject() {
            return this.myPsiElement.getProject();
        }

        public PsiFile getContainingFile() {
            return this.myPsiElement.getContainingFile();
        }

        public boolean isValid() {
            return this.myPsiElement.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            BaseNavigationItem that = (BaseNavigationItem)((Object)o);
            if (!this.myPsiElement.equals(that.myPsiElement)) {
                return false;
            }
            return this.myText.equals(that.myText);
        }

        public int hashCode() {
            int result2 = this.myPsiElement.hashCode();
            result2 = 31 * result2 + this.myText.hashCode();
            return result2;
        }
    }
}

