/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.ConverterManagerImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.xml.util.XmlEnumeratedValueReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericValueReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(GenericValueReferenceProvider.class);

    public final PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context2) {
        Object converter;
        DomInvocationHandler handler;
        DomManagerImpl domManager = DomManagerImpl.getDomManager(psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            handler = domManager.getDomHandler((XmlElement)((XmlTag)psiElement));
        } else if (psiElement instanceof XmlAttributeValue && psiElement.getParent() instanceof XmlAttribute) {
            handler = domManager.getDomHandler((XmlElement)((XmlAttribute)psiElement.getParent()));
        } else {
            return PsiReference.EMPTY_ARRAY;
        }
        if (handler == null || !GenericDomValue.class.isAssignableFrom(handler.getRawType())) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiElement instanceof XmlTag) {
            for (XmlText text : ((XmlTag)psiElement).getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)text))) continue;
                return PsiReference.EMPTY_ARRAY;
            }
        } else if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)psiElement))) {
            return PsiReference.EMPTY_ARRAY;
        }
        GenericDomValue domValue = (GenericDomValue)handler.getProxy();
        Referencing referencing = handler.getAnnotation(Referencing.class);
        if (referencing == null) {
            converter = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), (GenericDomValue)domValue);
        } else {
            Class clazz = referencing.value();
            converter = ((ConverterManagerImpl)domManager.getConverterManager()).getInstance(clazz);
        }
        PsiReference[] references = GenericValueReferenceProvider.createReferences(domValue, (XmlElement)psiElement, converter, handler, domManager);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiReference reference : references) {
                if (reference.isSoft()) continue;
                LOG.error("dom reference should be soft: " + reference + " (created by " + converter + ")");
            }
        }
        if (references.length > 0) {
            if (converter instanceof EnumConverter && !((EnumConverter)((Object)converter)).isExhaustive()) {
                return PsiReference.EMPTY_ARRAY;
            }
            context2.put(XmlEnumeratedValueReferenceProvider.SUPPRESS, (Object)Boolean.TRUE);
        }
        return references;
    }

    private static PsiReference[] createReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, DomInvocationHandler handler, DomManager domManager) {
        XmlFile file2 = handler.getFile();
        DomFileDescription description2 = domManager.getDomFileDescription(file2);
        if (description2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        ConvertContext context2 = ConvertContextFactory.createConvertContext((DomElement)domValue);
        List injectors = description2.getReferenceInjectors();
        if (!injectors.isEmpty()) {
            String unresolvedText = ElementManipulators.getValueText((PsiElement)psiElement);
            for (DomReferenceInjector each : injectors) {
                Collections.addAll(result2, each.inject(unresolvedText, (PsiElement)psiElement, context2));
            }
        }
        Collections.addAll(result2, GenericValueReferenceProvider.doCreateReferences(domValue, psiElement, converter, context2));
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static PsiReference @NotNull [] doCreateReferences(GenericDomValue domValue, XmlElement psiElement, Object converter, ConvertContext context2) {
        PsiReference[] references;
        if (converter instanceof CustomReferenceConverter && ((references = ((CustomReferenceConverter)converter).createReferences(domValue, (PsiElement)psiElement, context2)).length != 0 || !(converter instanceof ResolvingConverter))) {
            return references;
        }
        if (converter instanceof ResolvingConverter) {
            return new PsiReference[]{new GenericDomValueReference(domValue)};
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

