/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomDescriptionProvider;
import com.intellij.pom.PomTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ElementPresentationTemplate;
import org.jetbrains.annotations.NotNull;

public class DefaultDomTargetDescriptionProvider
extends PomDescriptionProvider {
    public String getElementDescription(@NotNull PomTarget element, @NotNull ElementDescriptionLocation location) {
        ElementPresentation presentation;
        if (!(element instanceof DomTarget)) {
            return null;
        }
        DomTarget target = (DomTarget)element;
        DomElement domElement = target.getDomElement();
        ElementPresentationTemplate template = domElement.getChildDescription().getPresentationTemplate();
        ElementPresentation elementPresentation = presentation = template != null ? template.createPresentation(domElement) : domElement.getPresentation();
        if (location == UsageViewTypeLocation.INSTANCE) {
            return presentation.getTypeName();
        }
        if (location == UsageViewNodeTextLocation.INSTANCE || location == UsageViewLongNameLocation.INSTANCE) {
            return presentation.getTypeName() + " " + StringUtil.notNullize((String)presentation.getElementName(), (String)"''");
        }
        if (location instanceof HighlightUsagesDescriptionLocation) {
            return presentation.getTypeName();
        }
        return null;
    }
}

