/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.nio.charset.MalformedInputException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002\u001a,\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a&\u0010\u0000\u001a\u00020\u000b*\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0013"}, d2={"getDirectoryTree", "", "dir", "Ljava/nio/file/Path;", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "excluded", "", "", "printContent", "", "getIndentString", "printFile", "file", "sortedFileList", "", "intellij.platform.testFramework"})
public final class FileTreePrinterKt {
    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent) {
        StringBuilder sb = new StringBuilder();
        FileTreePrinterKt.getDirectoryTree($this$getDirectoryTree, 0, sb, excluded, printContent);
        return sb.toString();
    }

    public static /* synthetic */ String getDirectoryTree$default(Path path, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return FileTreePrinterKt.getDirectoryTree(path, set, bl);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, null, false, 3, null);
    }

    private static final void getDirectoryTree(Path dir, int indent, StringBuilder sb, Set<String> excluded, boolean printContent) {
        List list = UtilKt.nullize(FileTreePrinterKt.sortedFileList(dir, excluded));
        if (list == null) {
            return;
        }
        List fileList = list;
        FileTreePrinterKt.getIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        sb.append(((Object)dir.getFileName()).toString());
        sb.append("/");
        sb.append("\n");
        for (Path file2 : fileList) {
            if (PathKt.isDirectory((Path)file2)) {
                FileTreePrinterKt.getDirectoryTree(file2, indent + 1, sb, excluded, printContent);
                continue;
            }
            FileTreePrinterKt.printFile(file2, indent + 1, sb, printContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Path> sortedFileList(Path dir, Set<String> excluded) {
        List list;
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl3 = false;
                Sequence sequence = CollectionsKt.asSequence((Iterable)stream);
                Collection collection = excluded;
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<Path, Boolean>(excluded){
                        final /* synthetic */ Set $excluded$inlined;
                        {
                            this.$excluded$inlined = set;
                            super(1);
                        }

                        public final boolean invoke(Path it) {
                            return !this.$excluded$inlined.contains(((Object)it.getFileName()).toString());
                        }
                    }));
                }
                List list2 = SequencesKt.toMutableList((Sequence)sequence);
                CollectionsKt.sort((List)list2);
                List list3 = list2;
                list = list3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            list = null;
        }
        return list;
    }

    private static final void printFile(Path file2, int indent, StringBuilder sb, boolean printContent) {
        FileTreePrinterKt.getIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        String fileName = ((Object)file2.getFileName()).toString();
        sb.append(fileName);
        sb.append("\n");
        if (printContent && !StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
            try {
                sb.append(PathKt.readChars((Path)file2)).append("\n\n");
            }
            catch (MalformedInputException malformedInputException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void getIndentString(int indent, StringBuilder sb) {
        int n = 0;
        int n2 = indent;
        while (n < n2) {
            void i2;
            sb.append("  ");
            ++i2;
        }
    }
}

