/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.ExternalClasspathClassLoader;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class BootstrapTestcaseSuite
extends Suite {
    public BootstrapTestcaseSuite(Class<?> suiteClass, RunnerBuilder builder2) throws InitializationError {
        super(builder2, suiteClass, (Class[])BootstrapTestcaseSuite.getClasses(BootstrapTestcaseSuite.getClassLoader(), BootstrapTestcaseSuite.getClassNames()));
    }

    private static Class<?>[] getClasses(ClassLoader classLoader, String[] testNames) {
        Class[] classArray = new Class[testNames.length];
        for (int i2 = 0; i2 < testNames.length; ++i2) {
            try {
                classArray[i2] = Class.forName(testNames[i2], true, classLoader);
                continue;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return classArray;
    }

    private static String[] getClassNames() {
        String testSpec = System.getProperty("bootstrap.testcase");
        if (testSpec == null) {
            throw new IllegalStateException("No tests specified via -Dbootstrap.testcase property");
        }
        return testSpec.split(",");
    }

    private static ClassLoader getClassLoader() {
        ExternalClasspathClassLoader.install();
        return Thread.currentThread().getContextClassLoader();
    }
}

