/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.ImperativeCommand;

public class StripTestDataMarkup
extends ActionOnFile {
    private static final String[] MARKUP = new String[]{"<caret>", "<ref>", "<selection>", "</selection>"};

    public StripTestDataMarkup(@NotNull PsiFile file2) {
        super(file2);
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        env.logMessage(this.toString());
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            Document document2 = this.getDocument();
            try {
                new ExpectedHighlightingData(document2, true, true, true, true, new ResourceBundle[0]).init();
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            for (String s : MARKUP) {
                StripTestDataMarkup.removeMarkup(document2, s);
            }
        });
        PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
    }

    private static void removeMarkup(Document document2, String marker) {
        document2.setText((CharSequence)StringUtil.replace((String)document2.getText(), (String)marker, (String)""));
    }

    public String toString() {
        return "Strip markup: " + Arrays.toString(MARKUP);
    }
}

