/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

final class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    private Project myProject;
    private volatile Module myModule;
    private final Set<Path> myFilesToDelete = new HashSet<Path>();
    private final Set<ModuleFixtureBuilder<?>> myModuleFixtureBuilders = new LinkedHashSet();
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private final String myName;
    private final Path myProjectPath;
    private final boolean myIsDirectoryBasedProject;
    private SdkLeakTracker myOldSdks;
    private AccessToken projectTracker;

    HeavyIdeaTestFixtureImpl(@NotNull String name, @Nullable Path projectPath, boolean isDirectoryBasedProject) {
        this.myName = name;
        this.myProjectPath = projectPath;
        this.myIsDirectoryBasedProject = isDirectoryBasedProject;
    }

    void addModuleFixtureBuilder(ModuleFixtureBuilder<?> builder2) {
        this.myModuleFixtureBuilders.add(builder2);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.projectTracker = ((TestProjectManager)ProjectManager.getInstance()).startTracking();
        this.setUpProject();
        EncodingManager.getInstance();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        if (this.myProject != null) {
            Project project2 = this.myProject;
            runAll = runAll.append(() -> {
                TestApplicationManagerKt.tearDownProjectAndApp(this.myProject);
                this.myProject = null;
            }, () -> {
                for (ModuleFixtureBuilder<?> moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                    moduleFixtureBuilder.getFixture().tearDown();
                }
            }, () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2));
        }
        JarFileSystemImpl.cleanupForNextTest();
        for (Path fileToDelete : this.myFilesToDelete) {
            runAll = runAll.append(() -> {
                List errors;
                try (Stream<Path> stream = Files.walk(fileToDelete, new FileVisitOption[0]);){
                    errors = stream.sorted(Comparator.reverseOrder()).map(x -> {
                        try {
                            Files.delete(x);
                            return null;
                        }
                        catch (IOException e) {
                            return e;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                catch (NoSuchFileException ignore) {
                    errors = Collections.emptyList();
                }
                CompoundRuntimeException.throwIfNotEmpty(errors);
            });
        }
        runAll.append(() -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> {
            if (this.myOldSdks != null) {
                this.myOldSdks.checkForJdkTableLeaks();
            }
        }, () -> HeavyPlatformTestCase.cleanupApplicationCaches(null)).run();
    }

    private void setUpProject() {
        this.myProject = HeavyTestHelper.openHeavyTestFixtureProject(this.generateProjectPath(), new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (HeavyIdeaTestFixtureImpl.this.myModule == null) {
                    HeavyIdeaTestFixtureImpl.this.myModule = module2;
                }
            }
        });
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            for (ModuleFixtureBuilder<?> moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                moduleFixtureBuilder.getFixture().setUp();
            }
            LightPlatformTestCase.clearUncommittedDocuments(this.myProject);
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        }));
    }

    @NotNull
    private Path generateProjectPath() {
        Path tempDirectory;
        if (this.myProjectPath == null) {
            tempDirectory = TemporaryDirectory.generateTemporaryPath(this.myName);
            this.myFilesToDelete.add(tempDirectory);
        } else {
            tempDirectory = this.myProjectPath;
        }
        return tempDirectory.resolve(this.myName + (this.myIsDirectoryBasedProject ? "" : ".ipr"));
    }

    private void initApplication() {
        TestApplicationManager.getInstance().setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.myProject);
        return this.myProject;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String rootPath, @NotNull @NonNls String relativePath, @NotNull @NonNls String fileText) throws IOException {
        VirtualFile dir = VfsUtil.createDirectories((String)(rootPath + "/" + PathUtil.getParentPath((String)relativePath)));
        VirtualFile[] virtualFile = new VirtualFile[1];
        WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
            virtualFile[0] = dir.createChildData((Object)this, StringUtil.getShortName((String)relativePath, (char)'/'));
            VfsUtil.saveText((VirtualFile)virtualFile[0], (String)fileText);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        });
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile[0]));
    }

    private final class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            VirtualFile[] contentRoots;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                if (HeavyIdeaTestFixtureImpl.this.myProject == null || HeavyIdeaTestFixtureImpl.this.myProject.isDisposed()) {
                    return null;
                }
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor != null) {
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return TextEditorProvider.getInstance().getTextEditor(editor);
                }
                FileEditorManagerEx manager2 = FileEditorManagerEx.getInstanceEx((Project)HeavyIdeaTestFixtureImpl.this.myProject);
                return manager2.getData(dataId, editor, editor.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(dataId) && (contentRoots = ProjectRootManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getContentRoots()).length > 0) {
                final PsiDirectory psiDirectory = PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).findDirectory(contentRoots[0]);
                return new IdeView(){

                    public PsiDirectory @NotNull [] getDirectories() {
                        return new PsiDirectory[]{psiDirectory};
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }
                };
            }
            return null;
        }
    }
}

