/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.ExtensionTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

public abstract class ParsingTestCase
extends UsefulTestCase {
    private PluginDescriptor myPluginDescriptor;
    private MockApplication myApp;
    protected MockProjectEx myProject;
    protected String myFilePrefix = "";
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;
    private ExtensionPointImpl<KeyedLazyInstance<ParserDefinition>> myLangParserDefinition;

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @NotNull
    protected MockApplication getApplication() {
        return this.myApp;
    }

    @Override
    protected void setUp() throws Exception {
        MockApplication app;
        super.setUp();
        this.myApp = app = MockApplication.setUp((Disposable)this.getTestRootDisposable());
        MutablePicoContainer appContainer = app.getPicoContainer();
        ComponentAdapter component = appContainer.getComponentAdapter((Object)ProgressManager.class.getName());
        if (component == null) {
            appContainer.registerComponentInstance((Object)ProgressManager.class.getName(), (Object)new ProgressManagerImpl());
        }
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager((Project)this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl((PsiManager)this.myPsiManager);
        appContainer.registerComponentInstance(MessageBus.class, (Object)app.getMessageBus());
        appContainer.registerComponentInstance(SchemeManagerFactory.class, (Object)new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        appContainer.registerComponentInstance(EditorFactory.class, (Object)editorFactory);
        app.registerService(FileDocumentManager.class, (Object)new MockFileDocumentManagerImpl(editorFactory::createDocument, FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        app.registerService(PluginUtil.class, (Object)new PluginUtilImpl());
        app.registerService(PsiBuilderFactory.class, (Object)new PsiBuilderFactoryImpl());
        app.registerService(DefaultASTFactory.class, (Object)new DefaultASTFactoryImpl());
        app.registerService(ReferenceProvidersRegistry.class, (Object)new ReferenceProvidersRegistryImpl());
        this.myProject.registerService(PsiDocumentManager.class, (Object)new MockPsiDocumentManager());
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(TreeAspect.class, new TreeAspect());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl((Project)this.myProject, (CachedValuesFactory)new PsiCachedValuesFactory((Project)this.myProject)));
        this.myProject.registerService(StartupManager.class, new StartupManagerImpl((Project)this.myProject));
        this.registerExtensionPoint(app.getExtensionArea(), (BaseExtensionPointName)FileTypeFactory.FILE_TYPE_FACTORY_EP, (Class)FileTypeFactory.class);
        this.registerExtensionPoint(app.getExtensionArea(), (BaseExtensionPointName)MetaLanguage.EP_NAME, (Class)MetaLanguage.class);
        this.myLangParserDefinition = app.getExtensionArea().registerFakeBeanPoint(LanguageParserDefinitions.INSTANCE.getName(), this.getPluginDescriptor());
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
            int length = this.myDefinitions.length;
            for (int i2 = 1; i2 < length; ++i2) {
                this.registerParserDefinition(this.myDefinitions[i2]);
            }
        }
        this.myProject.registerService(PomModel.class, new PomModelImpl((Project)this.myProject));
    }

    protected final void registerParserDefinition(final @NotNull ParserDefinition definition) {
        final Language language = definition.getFileNodeType().getLanguage();
        this.myLangParserDefinition.registerExtension((Object)new KeyedLazyInstance<ParserDefinition>(){

            public String getKey() {
                return language.getID();
            }

            @NotNull
            public ParserDefinition getInstance() {
                return definition;
            }
        });
        LanguageParserDefinitions.INSTANCE.clearCache(language);
        this.disposeOnTearDown(() -> LanguageParserDefinitions.INSTANCE.clearCache(language));
    }

    public void configureFromParserDefinition(@NotNull ParserDefinition definition, String extension) {
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.registerParserDefinition(definition);
        this.myApp.registerService(FileTypeManager.class, (Object)new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected final <T> void registerExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension) {
        this.registerExtensions(name, extension.getClass(), Collections.singletonList(extension));
    }

    protected final <T> void registerExtensions(@NotNull ExtensionPointName<T> name, @NotNull Class<T> extensionClass, @NotNull List<T> extensions) {
        ExtensionsAreaImpl area = this.myApp.getExtensionArea();
        ExtensionPointImpl<T> point = area.getExtensionPointIfRegistered(name.getName());
        if (point == null) {
            point = this.registerExtensionPoint(area, (BaseExtensionPointName<T>)name, extensionClass);
        }
        for (T extension : extensions) {
            point.registerExtension(extension);
        }
    }

    protected final <T> void addExplicitExtension(@NotNull LanguageExtension<T> collector, @NotNull Language language, @NotNull T object) {
        ExtensionsAreaImpl area = this.myApp.getExtensionArea();
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        if (!area.hasExtensionPoint(collector.getName())) {
            area.registerFakeBeanPoint(collector.getName(), pluginDescriptor);
        }
        LanguageExtensionPoint extension = new LanguageExtensionPoint(language.getID(), object);
        extension.setPluginDescriptor(pluginDescriptor);
        ExtensionTestUtil.addExtension(area, collector, extension);
    }

    protected final <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        this.registerExtensionPoint(this.myApp.getExtensionArea(), (BaseExtensionPointName<T>)extensionPointName, aClass);
    }

    protected <T> ExtensionPointImpl<T> registerExtensionPoint(@NotNull ExtensionsAreaImpl extensionArea, @NotNull BaseExtensionPointName<T> extensionPointName, @NotNull Class<T> extensionClass) {
        String name = extensionPointName.getName();
        if (extensionArea.hasExtensionPoint(name)) {
            return extensionArea.getExtensionPoint(name);
        }
        return extensionArea.registerPoint(name, extensionClass, this.getPluginDescriptor());
    }

    @NotNull
    private PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.myPluginDescriptor;
        if (pluginDescriptor == null) {
            this.myPluginDescriptor = pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId((String)(((Object)((Object)this)).getClass().getName() + "." + this.getName())), ParsingTestCase.class.getClassLoader());
        }
        return pluginDescriptor;
    }

    @NotNull
    public MockProjectEx getProject() {
        return this.myProject;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
        this.myFileFactory = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        return this.getTestName(this.myLowercaseFirstLetter);
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void ensureNoErrorElements() {
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private static final int TAB_WIDTH = 8;

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                String text = ParsingTestCase.this.myFile.getText();
                String[] lines = StringUtil.splitByLinesKeepSeparators((String)text);
                int offset = element.getTextOffset();
                LineColumn position = StringUtil.offsetToLineColumn((CharSequence)text, (int)offset);
                int lineNumber = position != null ? position.line : -1;
                int column = position != null ? position.column : 0;
                String line = StringUtil.trimTrailing((String)lines[lineNumber]);
                int numIndentTabs = StringUtil.countChars((CharSequence)line.subSequence(0, column), (char)'\t', (int)0, (boolean)true);
                int indentedColumn = column + numIndentTabs * 7;
                String lineWithNoTabs = StringUtil.repeat((String)" ", (int)(numIndentTabs * 8)) + line.substring(numIndentTabs).replace('\t', ' ');
                String errorUnderline = StringUtil.repeat((String)" ", (int)indentedColumn) + StringUtil.repeat((String)"^", (int)Math.max(1, element.getTextLength()));
                TestCase.fail((String)String.format("Unexpected error element: %s:%d:%d\n\n%s\n%s\n%s", ParsingTestCase.this.myFile.getName(), lineNumber + 1, column, lineWithNoTabs, errorUnderline, element.getErrorDescription()));
            }
        });
    }

    protected void doTest(boolean checkResult) {
        this.doTest(checkResult, false);
    }

    protected void doTest(boolean checkResult, boolean ensureNoErrorElements) {
        String name = this.getTestName();
        try {
            String text = this.loadFile(name + "." + this.myFileExt);
            this.myFile = this.createPsiFile(name, text);
            ParsingTestCase.ensureParsed(this.myFile);
            ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText((VirtualFile)this.myFile.getVirtualFile()));
            ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text, (String)Objects.requireNonNull(this.myFile.getViewProvider().getDocument()).getText());
            ParsingTestCase.assertEquals((String)"psi text mismatch", (String)text, (String)this.myFile.getText());
            ParsingTestCase.ensureCorrectReparse(this.myFile);
            if (checkResult) {
                this.checkResult(name, this.myFile);
                if (ensureNoErrorElements) {
                    this.ensureNoErrorElements();
                }
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest(String suffix) throws IOException {
        String name = this.getTestName();
        String text = this.loadFile(name + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name, text);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        this.checkResult(name + suffix, this.myFile);
    }

    protected void doCodeTest(@NotNull String code) throws IOException {
        String name = this.getTestName();
        this.myFile = this.createPsiFile("a", code);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name, this.myFile);
    }

    protected PsiFile createPsiFile(@NotNull String name, @NotNull String text) {
        return this.createFile(name + "." + this.myFileExt, text);
    }

    protected PsiFile createFile(@NotNull String name, @NotNull String text) {
        LightVirtualFile virtualFile = new LightVirtualFile(name, this.myLanguage, (CharSequence)text);
        virtualFile.setCharset(StandardCharsets.UTF_8);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile) {
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NotNull String targetDataName, @NotNull PsiFile file2) throws IOException {
        ParsingTestCase.doCheckResult(this.myFullDataPath, file2, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file2, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges) {
        ParsingTestCase.doCheckResult(testDataDir, file2, checkAllPsiRoots, targetDataName, skipSpaces, printRanges, false);
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file2, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges, boolean allTreesInSingleFile) {
        FileViewProvider provider2 = file2.getViewProvider();
        Set languages = provider2.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText((PsiElement)file2, skipSpaces, printRanges).trim());
            return;
        }
        if (allTreesInSingleFile) {
            String expectedName = targetDataName + ".txt";
            StringBuilder sb = new StringBuilder();
            ArrayList languagesList = new ArrayList(languages);
            ContainerUtil.sort(languagesList, Comparator.comparing(Language::getID));
            for (Language language : languagesList) {
                sb.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText((PsiElement)provider2.getPsi(language), skipSpaces, printRanges).trim()).append("\n").append(StringUtil.repeat((String)"-", (int)80)).append("\n");
            }
            ParsingTestCase.doCheckResult(testDataDir, expectedName, sb.toString());
        } else {
            for (Language language : languages) {
                PsiFile root = provider2.getPsi(language);
                ParsingTestCase.assertNotNull((String)("FileViewProvider " + provider2 + " didn't return PSI root for language " + language.getID()), (Object)root);
                String expectedName = targetDataName + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
            }
        }
    }

    protected void checkResult(@NotNull String actual) {
        String name = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name + ".txt", actual);
    }

    protected void checkResult(@NotNull String targetDataName, @NotNull String actual) {
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(@NotNull String fullPath, @NotNull String targetDataName, @NotNull String actual) {
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(@NotNull PsiElement file2, boolean skipSpaces, boolean printRanges) {
        return DebugUtil.psiToString((PsiElement)file2, (boolean)skipSpaces, (boolean)printRanges);
    }

    protected String loadFile(@NotNull String name) throws IOException {
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name);
    }

    public static String loadFileDefault(@NotNull String dir, @NotNull String name) throws IOException {
        return FileUtil.loadFile((File)new File(dir, name), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(@NotNull PsiFile file2) {
        file2.accept(new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file2) {
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file2, (boolean)false, (boolean)false);
        DebugUtil.performPsiModification((String)"ensureCorrectReparse", () -> {
            String fileText = file2.getText();
            DiffLog diffLog = new BlockSupportImpl().reparseRange(file2, file2.getNode(), TextRange.allOf((String)fileText), (CharSequence)fileText, (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)fileText);
            diffLog.performActualPsiChange(file2);
        });
        ParsingTestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file2, (boolean)false, (boolean)false));
    }

    public void registerMockInjectedLanguageManager() {
        this.registerExtensionPoint(this.myProject.getExtensionArea(), (BaseExtensionPointName)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, (Class)MultiHostInjector.class);
        this.registerExtensionPoint(this.myApp.getExtensionArea(), (BaseExtensionPointName)LanguageInjector.EXTENSION_POINT_NAME, (Class)LanguageInjector.class);
        this.myProject.registerService(DumbService.class, new MockDumbService((Project)this.myProject));
        this.myProject.registerService(InjectedLanguageManager.class, new InjectedLanguageManagerImpl((Project)this.myProject));
    }
}

