/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.UsefulTestCase;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSettingsTracker {
    private final Supplier<? extends CodeStyleSettings> myCurrentSettingsSupplier;
    private CodeStyleSettings myOldSettings;

    public CodeStyleSettingsTracker(@NotNull Supplier<? extends CodeStyleSettings> currentSettingsSupplier) {
        this.myCurrentSettingsSupplier = currentSettingsSupplier;
        CodeStyleSettings settings = currentSettingsSupplier.get();
        if (settings != null) {
            settings.getIndentOptions((FileType)StdFileTypes.JAVA);
            this.myOldSettings = CodeStyle.createTestSettings((CodeStyleSettings)settings);
        }
    }

    public void checkForSettingsDamage() {
        CodeStyleSettings oldSettings = this.myOldSettings;
        if (oldSettings == null) {
            return;
        }
        this.myOldSettings = null;
        UsefulTestCase.doCheckForSettingsDamage(oldSettings, this.myCurrentSettingsSupplier.get());
    }
}

