/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIUtil {
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";
    public static final NotificationGroup SSR_NOTIFICATION_GROUP = new NotificationGroup("Structural Search", NotificationDisplayType.STICKY_BALLOON, true, "Find", null, SSRBundle.message("structural.search.title", new Object[0]), null);
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String TYPE_REGEX = "TYPE REGEX";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    @NonNls
    public static final String CONTEXT = "CONTEXT";

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project2, boolean editable, @Nullable TemplateContextType contextType) {
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project2) : EditorFactory.getInstance().createViewer(doc, project2);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        return editor;
    }

    public static void setContent(@NotNull Editor editor, String text) {
        String value = text != null ? text : "";
        Document document2 = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)SS_GROUP, () -> document2.replaceString(0, document2.getTextLength(), (CharSequence)value), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, String text) {
        String value = text != null ? text : "";
        Document document2 = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)SS_GROUP, () -> document2.replaceString(0, document2.getTextLength(), (CharSequence)value), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(Configuration config, SearchContext context2) {
        StructuralSearchAction.triggerAction(config, context2, !(config instanceof SearchConfiguration));
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchOptions options2 = configuration.getMatchOptions();
        MatchVariableConstraint varInfo = options2.getVariableConstraint(varName);
        if (varInfo != null) {
            return varInfo;
        }
        return configuration.getMatchOptions().addNewVariableConstraint(varName);
    }

    public static ReplacementVariableDefinition getOrAddReplacementVariable(String varName, Configuration configuration) {
        ReplaceOptions replaceOptions = configuration.getReplaceOptions();
        ReplacementVariableDefinition definition = replaceOptions.getVariableDefinition(varName);
        if (definition != null) {
            return definition;
        }
        return replaceOptions.addNewVariableDefinition(varName);
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        if ("__context__".equals(varName)) {
            for (String name : matchOptions.getVariableConstraintNames()) {
                if (name.equals("__context__") || !matchOptions.getVariableConstraint(name).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint constraint = matchOptions.getVariableConstraint(varName);
        if (constraint == null) {
            return false;
        }
        return constraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(Supplier<? extends Configuration> configurationProducer) {
        return UIUtil.installCompleteMatchInfo(new JLabel(AllIcons.Actions.ListFiles), configurationProducer, null);
    }

    @NotNull
    public static JComponent installCompleteMatchInfo(final JLabel completeMatchInfo, final Supplier<? extends Configuration> configurationProducer, final Consumer<? super String> linkConsumer) {
        completeMatchInfo.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 20000);
        completeMatchInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent ignore) {
                if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
                    return;
                }
                Configuration configuration = (Configuration)configurationProducer.get();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                if (matchOptions.getSearchPattern().isEmpty()) {
                    return;
                }
                MatchVariableConstraint constraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    constraint.setPartOfSearchResults(true);
                }
                String filterText = StringUtil.escapeXmlEntities((String)SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(constraint, linkConsumer == null)));
                if (linkConsumer != null && !"__context__".equals(configuration.getCurrentVariableName())) {
                    filterText = SubstitutionShortInfoHandler.appendLinkText(filterText, "__context__");
                }
                HyperlinkListener listener = e -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && linkConsumer != null) {
                        linkConsumer.accept("__context__");
                        IdeTooltipManager.getInstance().hideCurrentNow(true);
                    }
                };
                TooltipWithClickableLinks tooltip = new TooltipWithClickableLinks((JComponent)completeMatchInfo, filterText, listener);
                Rectangle bounds = completeMatchInfo.getBounds();
                tooltip.setHint(true).setExplicitClose(true).setPreferredPosition(Balloon.Position.below).setPoint(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height));
                IdeTooltipManager.getInstance().show((IdeTooltip)tooltip, true);
                if (linkConsumer == null) {
                    configuration.setCurrentVariableName("__context__");
                }
            }
        });
        return completeMatchInfo;
    }

    public static EditorTextField createTextComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.txt", project2);
    }

    public static EditorTextField createRegexComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.regexp", project2);
    }

    public static EditorTextField createScriptComponent(String text, Project project2) {
        return UIUtil.createEditorComponent(text, "1.groovy", project2);
    }

    @NotNull
    public static EditorTextField createEditorComponent(String text, String fileName, Project project2) {
        FileType fileType = UIUtil.getFileType(fileName);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, fileType, (CharSequence)text, -1L, true);
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        return new EditorTextField(document2, project2, fileType);
    }

    private static FileType getFileType(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile profile;
        PsiFile file2 = searchContext.getFile();
        PsiElement context2 = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && file2 != null) {
            int offset = editor.getCaretModel().getOffset();
            context2 = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(file2, offset);
            if (context2 == null) {
                context2 = file2.findElementAt(offset);
            }
            if (context2 != null) {
                context2 = context2.getParent();
            }
            if (context2 == null) {
                context2 = file2;
            }
        }
        if (context2 != null && (profile = StructuralSearchUtil.getProfileByLanguage(language = context2.getLanguage())) != null) {
            LanguageFileType fileType = profile.detectFileType(context2);
            return fileType != null ? fileType : language.getAssociatedFileType();
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    @NotNull
    public static Document createDocument(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text, @NotNull StructuralSearchProfile profile) {
        String contextId = patternContext == null ? null : patternContext.getId();
        PsiCodeFragment codeFragment = profile.createCodeFragment(project2, text, contextId);
        if (codeFragment == null) {
            codeFragment = UIUtil.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            return doc;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)text);
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text, boolean editable, @NotNull StructuralSearchProfile profile) {
        Document doc;
        PsiCodeFragment codeFragment = profile.createCodeFragment(project2, text, null);
        if (codeFragment == null) {
            codeFragment = UIUtil.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled((PsiFile)codeFragment, false);
        } else {
            doc = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        return UIUtil.createEditor(doc, project2, editable, UIUtil.getTemplateContextType(profile));
    }

    private static PsiFile createFileFragment(@NotNull Project project2, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text) {
        String name = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        return dialect == null ? factory.createFileFromText(name, (FileType)fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name, dialect, (CharSequence)text, true, true);
    }

    public static TemplateContextType getTemplateContextType(StructuralSearchProfile profile) {
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz);
    }
}

