/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    protected final SearchContext mySearchContext;
    protected final Configuration myConfiguration;
    private MatchingProcess process;
    private FindUsagesProcessPresentation myProcessPresentation;

    public SearchCommand(Configuration configuration, SearchContext searchContext) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    protected UsageViewContext createUsageViewContext() {
        Runnable searchStarter = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, searchStarter);
    }

    public void startSearching() {
        final UsageViewContext context2 = this.createUsageViewContext();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        context2.configure(presentation);
        this.myProcessPresentation = new FindUsagesProcessPresentation(presentation);
        this.myProcessPresentation.setShowNotFoundMessage(true);
        this.myProcessPresentation.setShowPanelIfOnlyOneUsage(true);
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget target = context2.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(target);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{target}, () -> new UsageSearcher(){

            public void generate(@NotNull Processor<? super Usage> processor2) {
                SearchCommand.this.findUsages(processor2);
            }
        }, this.myProcessPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                context2.setUsageView(usageView);
                context2.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }
        });
    }

    public void findUsages(final Processor<? super Usage> processor2) {
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setIndeterminate(false);
        MatchResultSink sink = new MatchResultSink(){
            int count;

            @Override
            public void setMatchingProcess(MatchingProcess _process) {
                SearchCommand.this.process = _process;
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(PsiFile element) {
                VirtualFile virtualFile = element.getVirtualFile();
                if (virtualFile != null) {
                    progress.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progress.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progress;
            }

            @Override
            public void newMatch(MatchResult result2) {
                UsageInfo info;
                if ("__multi_line__".equals(result2.getName())) {
                    int start = -1;
                    int end = -1;
                    PsiElement parent = result2.getMatch().getParent();
                    for (MatchResult matchResult : result2.getChildren()) {
                        int newend;
                        PsiElement el = matchResult.getMatch();
                        int elementStart = el.getTextRange().getStartOffset();
                        if (start == -1 || start > elementStart) {
                            start = elementStart;
                        }
                        if ((newend = elementStart + el.getTextLength()) <= end) continue;
                        end = newend;
                    }
                    int parentStart = parent.getTextRange().getStartOffset();
                    int startOffset = start - parentStart;
                    info = new UsageInfo(parent, startOffset, end - parentStart);
                } else {
                    PsiElement match = result2.getMatch();
                    if (!match.isPhysical()) {
                        return;
                    }
                    info = new UsageInfo(match);
                }
                UsageInfo2UsageAdapter usage = new UsageInfo2UsageAdapter(info);
                SearchCommand.this.foundUsage(result2, (Usage)usage);
                processor2.process((Object)usage);
                ++this.count;
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject(), this.myConfiguration.getMatchOptions()).findMatches(sink);
        }
        catch (StructuralSearchException e) {
            this.myProcessPresentation.setShowNotFoundMessage(false);
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(e instanceof StructuralSearchScriptException ? SSRBundle.message("search.script.problem", e.getCause()) : SSRBundle.message("search.template.problem", e.getMessage())).setImportant(true).notify(this.mySearchContext.getProject());
        }
    }

    protected void findStarted() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(true);
    }

    protected void findEnded() {
        StructuralSearchPlugin.getInstance(this.mySearchContext.getProject()).setSearchInProgress(false);
    }

    protected void foundUsage(MatchResult result2, Usage usage) {
    }
}

