/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinkComboBox
extends JBComboBoxLabel {
    private final List<String> myItems = new SmartList();
    private String mySelectedItem;
    private String myDefaultItem;
    private NullableConsumer<? super String> myConsumer;

    LinkComboBox(String defaultItem) {
        this.setDefaultItem(defaultItem);
        this.setForeground(JBUI.CurrentTheme.Link.linkColor());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkComboBox.this.showPopup();
            }
        });
    }

    public void setItemConsumer(@Nullable NullableConsumer<? super String> consumer) {
        this.myConsumer = consumer;
    }

    public void setItems(@NotNull Collection<String> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("items needs to contain at least one item");
        }
        this.myItems.clear();
        this.myItems.addAll(items);
        if (!this.myItems.contains(this.mySelectedItem)) {
            this.setSelectedItem(this.myDefaultItem != null ? this.myDefaultItem : this.myItems.get(0));
        }
    }

    public String getSelectedItem() {
        return this.mySelectedItem;
    }

    public void setSelectedItem(String selectedItem) {
        if (!this.myItems.contains(selectedItem)) {
            throw new IllegalArgumentException("selected item is not contained in items");
        }
        this.mySelectedItem = selectedItem;
        this.setText(selectedItem);
    }

    public void setDefaultItem(String defaultItem) {
        this.myDefaultItem = defaultItem;
        this.setText(defaultItem);
    }

    void showPopup() {
        if (!this.isEnabled()) {
            return;
        }
        BaseListPopupStep<String> list = new BaseListPopupStep<String>(null, this.myItems){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                LinkComboBox.this.setSelectedItem(selectedValue);
                if (LinkComboBox.this.myConsumer != null) {
                    LinkComboBox.this.myConsumer.consume((Object)selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public int getDefaultOptionIndex() {
                return LinkComboBox.this.myItems.indexOf(LinkComboBox.this.mySelectedItem);
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)list);
        popup.show(new RelativePoint((Component)((Object)this), new Point(-2, 0)));
    }
}

