/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindBundle;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryComboBoxWithButtons
extends JPanel {
    @NotNull
    private final ComponentWithBrowseButton<ComboBox<String>> myDirectoryComboBox = new ComponentWithBrowseButton((JComponent)new ComboBox(200), null);
    private volatile boolean myUpdating = false;
    boolean myRecursive = true;
    Runnable myCallback;

    public DirectoryComboBoxWithButtons(@NotNull Project project2) {
        super(new BorderLayout());
        final ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.addActionListener(e -> {
            if (this.myUpdating) {
                return;
            }
            VirtualFile directory = this.getDirectory();
            ComboBox source = (ComboBox)e.getSource();
            if (directory == null) {
                source.putClientProperty((Object)"JComponent.outline", (Object)"error");
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(SSRBundle.message("popup.content.directory", new Object[0]), AllIcons.General.BalloonError, MessageType.ERROR.getPopupBackground(), null).createBalloon();
                balloon.show(new RelativePoint((Component)source, new Point(source.getWidth() / 2, 0)), Balloon.Position.above);
                source.requestFocus();
            } else {
                source.putClientProperty((Object)"JComponent.outline", null);
            }
            if (this.myCallback != null && directory != null) {
                this.myCallback.run();
            }
        });
        comboBox.setEditable(true);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setForcedToUseIdeaFileChooser(true);
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            FileChooserFactory.getInstance().installFileCompletion((JTextField)editorComponent, descriptor, true, null);
        }
        comboBox.setMaximumRowCount(8);
        this.myDirectoryComboBox.addBrowseFolderListener(null, null, project2, descriptor, (TextComponentAccessor)new TextComponentAccessor<ComboBox<String>>(){

            public String getText(ComboBox comboBox2) {
                return comboBox2.getEditor().getItem().toString();
            }

            public void setText(ComboBox component, @NotNull String text) {
                comboBox.getEditor().setItem(text);
            }
        });
        RecursiveAction recursiveDirectoryAction = new RecursiveAction();
        int mnemonicModifiers = SystemInfo.isMac ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)this.myDirectoryComboBox);
        this.add((Component)this.myDirectoryComboBox, "Center");
        this.add((Component)FindPopupPanel.createToolbar((AnAction[])new AnAction[]{recursiveDirectoryAction}), "East");
    }

    public ComboBox<String> getComboBox() {
        return (ComboBox)this.myDirectoryComboBox.getChildComponent();
    }

    public void setCallback(Runnable callback) {
        this.myCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        this.myUpdating = true;
        try {
            comboBox.removeAllItems();
            for (int i2 = recentDirectories.size() - 1; i2 >= 0; --i2) {
                comboBox.addItem((Object)recentDirectories.get(i2));
            }
        }
        finally {
            this.myUpdating = false;
        }
    }

    public void setDirectory(@NotNull VirtualFile directory) {
        String url = directory.getPresentableUrl();
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        comboBox.getEditor().setItem(url);
        this.setDirectory(url);
    }

    private void setDirectory(String path) {
        ((ComboBox)this.myDirectoryComboBox.getChildComponent()).setSelectedItem((Object)path);
    }

    @Nullable
    public VirtualFile getDirectory() {
        ComboBox comboBox = (ComboBox)this.myDirectoryComboBox.getChildComponent();
        String directoryName = (String)comboBox.getSelectedItem();
        if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
            return null;
        }
        String path = FileUtil.toSystemIndependentName((String)directoryName);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        return virtualFile == null || !virtualFile.isDirectory() ? null : virtualFile;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    public void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    private class RecursiveAction
    extends ToggleAction {
        RecursiveAction() {
            super(FindBundle.messagePointer((String)"find.scope.directory.recursive.checkbox", (Object[])new Object[0]), FindBundle.messagePointer((String)"find.recursively.hint", (Object[])new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return DirectoryComboBoxWithButtons.this.myRecursive;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            DirectoryComboBoxWithButtons.this.myRecursive = state;
            DirectoryComboBoxWithButtons.this.myCallback.run();
        }
    }
}

