/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SSBasedInspectionCompiledPatternsCache {
    private static final Logger LOG = Logger.getInstance(SSBasedInspectionCompiledPatternsCache.class);
    private static final Key<Map<Configuration, Matcher>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");
    private final Project myProject;

    public static SSBasedInspectionCompiledPatternsCache getInstance(@NotNull Project project2) {
        return (SSBasedInspectionCompiledPatternsCache)ServiceManager.getService((Project)project2, SSBasedInspectionCompiledPatternsCache.class);
    }

    private SSBasedInspectionCompiledPatternsCache(Project project2) {
        this.myProject = project2;
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> project2.putUserData(COMPILED_OPTIONS_KEY, null), (Disposable)project2);
    }

    @NotNull
    Map<Configuration, Matcher> getCompiledOptions(@NotNull List<Configuration> configurations) {
        Map<Configuration, Matcher> cache = this.getCompiledOptions(configurations, (Map)this.myProject.getUserData(COMPILED_OPTIONS_KEY));
        this.myProject.putUserData(COMPILED_OPTIONS_KEY, cache);
        return cache;
    }

    Map<Configuration, Matcher> getCompiledOptions(@NotNull List<Configuration> configurations, @Nullable Map<Configuration, Matcher> cache) {
        if (SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache)) {
            return cache;
        }
        HashMap<Configuration, Matcher> newCache = new HashMap<Configuration, Matcher>();
        if (cache != null && !cache.isEmpty()) {
            newCache.putAll(cache);
            newCache.keySet().retainAll(configurations);
        }
        if (configurations.size() != newCache.size()) {
            for (Configuration configuration : configurations) {
                if (newCache.containsKey(configuration)) continue;
                try {
                    MatchOptions matchOptions = configuration.getMatchOptions();
                    CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.myProject, matchOptions, false, true);
                    Matcher matcher = compiledPattern == null ? null : new Matcher(this.myProject, matchOptions, compiledPattern);
                    newCache.put(configuration, matcher);
                }
                catch (StructuralSearchException e) {
                    LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + '\"', (Throwable)e);
                    newCache.put(configuration, null);
                }
            }
        }
        return Collections.unmodifiableMap(newCache);
    }

    @Contract(value="_, null -> false")
    private static boolean areConfigurationsInCache(List<Configuration> configurations, @Nullable Map<Configuration, Matcher> cache) {
        return cache != null && configurations.size() == cache.size() && configurations.stream().allMatch(key -> cache.containsKey(key));
    }
}

