/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionHandler
extends MatchingHandler {
    private final String name;
    private final int maxOccurs;
    private final int minOccurs;
    private final boolean greedy;
    private boolean target;
    private MatchPredicate predicate;
    private MatchingHandler matchHandler;
    private boolean subtype;
    private boolean strictSubtype;
    private int matchedOccurs;
    private int totalMatchedOccurs = -1;
    private MatchResultImpl myNestedResult;
    private boolean myRepeatedVar = false;
    private static final NodeFilter VARS_DELIM_FILTER = new NodeFilter(){

        @Override
        public boolean accepts(PsiElement element) {
            if (element == null) {
                return false;
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile == null) {
                return false;
            }
            return profile.canBeVarDelimiter(element);
        }
    };

    public SubstitutionHandler(String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs must be greater or equal to 0");
        }
        if (minOccurs > maxOccurs) {
            throw new IllegalArgumentException("maxOccurs must be greater equal to minOccurs");
        }
        this.name = name;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.target = target;
        this.greedy = greedy;
    }

    public boolean isSubtype() {
        return this.subtype;
    }

    public boolean isStrictSubtype() {
        return this.strictSubtype;
    }

    public void setStrictSubtype(boolean strictSubtype) {
        this.strictSubtype = strictSubtype;
    }

    public void setSubtype(boolean subtype) {
        this.subtype = subtype;
    }

    public void setPredicate(@NotNull MatchPredicate handler) {
        this.predicate = handler;
    }

    public MatchPredicate getPredicate() {
        return this.predicate;
    }

    @Nullable
    public RegExpPredicate findRegExpPredicate() {
        return SubstitutionHandler.findRegExpPredicate(this.getPredicate());
    }

    public void setRepeatedVar(boolean repeatedVar) {
        this.myRepeatedVar = repeatedVar;
    }

    private static RegExpPredicate findRegExpPredicate(MatchPredicate start) {
        if (start == null) {
            return null;
        }
        if (start instanceof RegExpPredicate) {
            return (RegExpPredicate)start;
        }
        if (start instanceof AndPredicate) {
            AndPredicate binary = (AndPredicate)start;
            RegExpPredicate result2 = SubstitutionHandler.findRegExpPredicate(binary.getFirst());
            if (result2 != null) {
                return result2;
            }
            return SubstitutionHandler.findRegExpPredicate(binary.getSecond());
        }
        if (start instanceof NotPredicate) {
            return null;
        }
        return null;
    }

    private boolean validateOneMatch(PsiElement match, int start, int end, MatchResult result2, MatchContext matchContext) {
        if (!this.myRepeatedVar) {
            return true;
        }
        if (match != null) {
            if (start == 0 && end == -1 && result2.getStart() == 0 && result2.getEnd() == -1) {
                return matchContext.getMatcher().match(match, result2.getMatch());
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
            assert (profile != null);
            return profile.getText(match, start, end).equals(result2.getMatchImage());
        }
        return result2.getMatchImage() == null;
    }

    public boolean validate(PsiElement match, MatchContext context2) {
        return this.validate(match, 0, -1, context2);
    }

    public boolean validate(PsiElement match, int start, int end, MatchContext context2) {
        MatchResultImpl previous;
        MatchResult result2;
        if (match == null || this.predicate != null && !this.predicate.match(match, start, end, context2)) {
            return false;
        }
        MatchResultImpl matchResultImpl = result2 = context2.hasResult() ? context2.getResult().findChild(this.name) : null;
        if (result2 == null && (previous = context2.getPreviousResult()) != null) {
            result2 = MatchResultImpl.findChildDeep(previous, this.name);
        }
        if (result2 != null) {
            if (this.minOccurs == 1 && this.maxOccurs == 1) {
                return this.validateOneMatch(match, start, end, result2, context2);
            }
            if (this.maxOccurs > 1 && this.totalMatchedOccurs != -1) {
                if (((MatchResult)result2).isMultipleMatch()) {
                    List<MatchResult> children = ((MatchResult)result2).getChildren();
                    int size = children.size();
                    if (this.matchedOccurs >= size) {
                        return false;
                    }
                    if (size != 0) {
                        result2 = children.get(this.matchedOccurs);
                    }
                }
                return this.validateOneMatch(match, start, end, result2, context2);
            }
        }
        return true;
    }

    @Override
    public boolean match(PsiElement node2, PsiElement match, MatchContext context2) {
        if (!super.match(node2, match, context2)) {
            return false;
        }
        return this.matchHandler == null ? context2.getMatcher().match(node2, match) : this.matchHandler.match(node2, match, context2);
    }

    public void addResult(@NotNull PsiElement match, MatchContext context2) {
        this.addResult(match, 0, -1, context2);
    }

    public void addResult(@NotNull PsiElement match, int start, int end, MatchContext context2) {
        if (this.totalMatchedOccurs == -1) {
            MatchResultImpl matchResult = context2.getResult();
            MatchResultImpl substitution2 = matchResult.findChild(this.name);
            if (substitution2 == null) {
                matchResult.addChild(this.createMatch(match, start, end));
            } else if (this.maxOccurs > 1) {
                MatchResultImpl result2 = this.createMatch(match, start, end);
                if (!substitution2.isMultipleMatch()) {
                    MatchResultImpl sonresult = new MatchResultImpl(substitution2.getName(), substitution2.getMatchImage(), substitution2.getMatchRef(), substitution2.getStart(), substitution2.getEnd(), this.target);
                    substitution2.setMatchRef(new SmartPsiPointer(match));
                    substitution2.setMultipleMatch(true);
                    if (substitution2.isScopeMatch()) {
                        substitution2.setScopeMatch(false);
                        sonresult.setScopeMatch(true);
                        for (MatchResult r : substitution2.getChildren()) {
                            sonresult.addChild(r);
                        }
                        substitution2.removeChildren();
                    }
                    substitution2.addChild(sonresult);
                }
                substitution2.addChild(result2);
            }
        }
    }

    public boolean handle(PsiElement match, MatchContext context2) {
        return this.handle(match, 0, -1, context2);
    }

    public boolean handle(PsiElement match, int start, int end, MatchContext context2) {
        if (!this.validate(match, start, end, context2)) {
            this.myNestedResult = null;
            return false;
        }
        if (!"__context__".equals(this.name)) {
            this.addResult(match, start, end, context2);
        }
        return true;
    }

    private MatchResultImpl createMatch(@NotNull PsiElement match, int start, int end) {
        MatchResultImpl result2;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        assert (profile != null);
        String image = profile.getText(match, start, end);
        SmartPsiPointer ref = new SmartPsiPointer(match);
        MatchResultImpl matchResultImpl = result2 = this.myNestedResult == null ? new MatchResultImpl(this.name, image, ref, start, end, this.target) : this.myNestedResult;
        if (this.myNestedResult != null) {
            this.myNestedResult.setName(this.name);
            this.myNestedResult.setMatchImage(image);
            this.myNestedResult.setMatchRef(ref);
            this.myNestedResult.setStart(start);
            this.myNestedResult.setEnd(end);
            this.myNestedResult.setTarget(this.target);
            this.myNestedResult = null;
        }
        return result2;
    }

    @Override
    boolean validate(MatchContext context2, int matchedOccurs) {
        if (this.minOccurs > matchedOccurs) {
            return false;
        }
        return this.maxOccurs >= matchedOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    private void removeLastResults(int numberOfResults, MatchContext context2) {
        if (numberOfResults == 0) {
            return;
        }
        MatchResultImpl substitution2 = context2.getResult().findChild(this.name);
        if (substitution2 != null) {
            if (substitution2.hasChildren()) {
                while (numberOfResults > 0) {
                    --numberOfResults;
                    MatchResult matchResult = substitution2.removeLastChild();
                    context2.removeMatchedNode(matchResult.getMatch());
                }
                if (!substitution2.hasChildren()) {
                    context2.getResult().removeChild(this.name);
                }
            } else {
                MatchResult matchResult = context2.getResult().removeChild(this.name);
                assert (matchResult != null);
                context2.removeMatchedNode(matchResult.getMatch());
            }
        }
    }

    @Override
    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context2) {
        return this.doMatchSequentially(patternNodes, matchNodes, context2);
    }

    protected boolean doMatchSequentiallyBySimpleHandler(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context2) {
        boolean oldValue = context2.shouldRecursivelyMatch();
        context2.setShouldRecursivelyMatch(false);
        boolean result2 = super.matchSequentially(patternNodes, matchNodes, context2);
        context2.setShouldRecursivelyMatch(oldValue);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMatchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context2) {
        int previousMatchedOccurs = this.matchedOccurs;
        FilteringNodeIterator fNodes = new FilteringNodeIterator(matchNodes, VARS_DELIM_FILTER);
        try {
            CompiledPattern pattern = context2.getPattern();
            PsiElement currentPatternNode = patternNodes.current();
            MatchingHandler handler = pattern.getHandler(currentPatternNode);
            this.matchedOccurs = 0;
            boolean flag = false;
            while (fNodes.hasNext() && this.matchedOccurs < this.minOccurs) {
                if (handler.match(currentPatternNode, matchNodes.current(), context2)) {
                    ++this.matchedOccurs;
                } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                fNodes.advance();
                flag = true;
            }
            if (this.matchedOccurs != this.minOccurs) {
                this.removeLastResults(this.matchedOccurs, context2);
                fNodes.rewind(this.matchedOccurs);
                boolean bl = false;
                return bl;
            }
            if (this.greedy) {
                while (fNodes.hasNext() && this.matchedOccurs < this.maxOccurs) {
                    if (handler.match(currentPatternNode, matchNodes.current(), context2)) {
                        ++this.matchedOccurs;
                    } else if (handler instanceof TopLevelMatchingHandler && this.matchedOccurs == 0 || currentPatternNode instanceof PsiComment || !(matchNodes.current() instanceof PsiComment)) break;
                    fNodes.advance();
                    flag = true;
                }
                if (flag) {
                    fNodes.rewind();
                    matchNodes.advance();
                }
                patternNodes.advance();
                if (patternNodes.hasNext()) {
                    MatchingHandler nextHandler = pattern.getHandler(patternNodes.current());
                    while (this.matchedOccurs >= this.minOccurs && patternNodes.hasNext()) {
                        if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                            this.totalMatchedOccurs = this.matchedOccurs;
                            boolean bl = true;
                            return bl;
                        }
                        if (this.matchedOccurs > 0) {
                            matchNodes.rewind();
                            this.removeLastResults(1, context2);
                        }
                        --this.matchedOccurs;
                    }
                    if (this.matchedOccurs > 0) {
                        this.removeLastResults(this.matchedOccurs, context2);
                    }
                    patternNodes.rewind();
                } else {
                    if (handler.isMatchSequentiallySucceeded(matchNodes)) {
                        boolean nextHandler = this.checkSameOccurrencesConstraint(context2);
                        return nextHandler;
                    }
                    this.removeLastResults(this.matchedOccurs, context2);
                }
                boolean nextHandler = false;
                return nextHandler;
            }
            patternNodes.advance();
            if (flag) {
                fNodes.rewind();
                matchNodes.advance();
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = pattern.getHandler(patternNodes.current());
                flag = false;
                while (matchNodes.hasNext() && this.matchedOccurs <= this.maxOccurs) {
                    if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                        boolean bl = this.checkSameOccurrencesConstraint(context2);
                        return bl;
                    }
                    if (flag) {
                        matchNodes.rewind();
                        fNodes.advance();
                    }
                    if (handler.match(patternNodes.current(), matchNodes.current(), context2)) {
                        ++this.matchedOccurs;
                    } else {
                        patternNodes.rewind();
                        this.removeLastResults(this.matchedOccurs, context2);
                        boolean bl = false;
                        return bl;
                    }
                    matchNodes.advance();
                    flag = true;
                }
                patternNodes.rewind();
                this.removeLastResults(this.matchedOccurs, context2);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.checkSameOccurrencesConstraint(context2);
            return bl;
        }
        finally {
            this.matchedOccurs = previousMatchedOccurs;
        }
    }

    private boolean checkSameOccurrencesConstraint(MatchContext context2) {
        MatchResultImpl result2;
        if (this.totalMatchedOccurs == -1) {
            this.totalMatchedOccurs = this.matchedOccurs;
            return true;
        }
        MatchResultImpl matchResultImpl = result2 = context2.hasResult() ? context2.getResult().findChild(this.name) : null;
        if (result2 == null && context2.getPreviousResult() != null) {
            result2 = context2.getPreviousResult().findChild(this.name);
        }
        return result2 == null || ((MatchResult)result2).size() == this.matchedOccurs;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public void setMatchHandler(MatchingHandler matchHandler) {
        this.matchHandler = matchHandler;
    }

    public boolean isTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalMatchedOccurs = -1;
    }

    @Override
    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        if (this.maxOccurs > 1) {
            return false;
        }
        return super.shouldAdvanceThePatternFor(patternElement, matchedElement);
    }

    public void setNestedResult(MatchResultImpl nestedResult) {
        this.myNestedResult = nestedResult;
    }

    public MatchResultImpl getNestedResult() {
        return this.myNestedResult;
    }
}

