/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkippingHandler
extends MatchingHandler
implements DelegatingHandler {
    private final MatchingHandler myDelegate;

    public SkippingHandler(@NotNull MatchingHandler delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext matchContext) {
        if (patternNode == null || matchedNode == null || matchedNode.getClass() == patternNode.getClass()) {
            return this.myDelegate.match(patternNode, matchedNode, matchContext);
        }
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNecessary(patternNode);
        matchedNode = SkippingHandler.skipNodeIfNecessary(matchedNode);
        if (newPatternNode != patternNode) {
            return matchContext.getPattern().getHandler(newPatternNode).match(newPatternNode, matchedNode, matchContext);
        }
        return this.myDelegate.match(patternNode, matchedNode, matchContext);
    }

    @Override
    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context2) {
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNecessary(patternNode);
        if (newPatternNode != patternNode) {
            return context2.getPattern().getHandler(newPatternNode).canMatch(newPatternNode, matchedNode, context2);
        }
        return this.myDelegate.canMatch(patternNode, matchedNode, context2);
    }

    @Override
    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context2) {
        return this.myDelegate.matchSequentially(patternNodes, matchNodes, context2);
    }

    @Override
    protected boolean isMatchSequentiallySucceeded(NodeIterator matchNodes) {
        return this.myDelegate.isMatchSequentiallySucceeded(matchNodes);
    }

    @Override
    public MatchingHandler getDelegate() {
        return this.myDelegate;
    }

    @Nullable
    public static PsiElement getOnlyNonWhitespaceChild(PsiElement element) {
        PsiElement onlyChild = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (DuplocatorUtil.isIgnoredNode(element) || child.getTextLength() == 0) continue;
            if (onlyChild != null) {
                return null;
            }
            onlyChild = child;
        }
        return onlyChild;
    }

    @Nullable
    @Contract(value="null -> null;!null -> !null;")
    public static PsiElement skipNodeIfNecessary(PsiElement element) {
        return SkippingHandler.skipNodeIfNecessary(element, null, null);
    }

    @Nullable
    @Contract(value="null, _, _ -> null;!null, _, _ -> !null;")
    public static PsiElement skipNodeIfNecessary(PsiElement element, EquivalenceDescriptor descriptor, NodeFilter filter) {
        return DuplocatorUtil.skipNodeIfNecessary(element, descriptor, filter != null ? filter : LexicalNodesFilter.getInstance());
    }
}

