/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class MatchingHandler {
    protected NodeFilter filter;
    private PsiElement pinnedElement;
    protected static ClearStateVisitor clearingVisitor = new ClearStateVisitor();

    public void setFilter(NodeFilter filter) {
        this.filter = filter;
    }

    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context2) {
        return patternNode == null ? matchedNode == null : this.canMatch(patternNode, matchedNode, context2);
    }

    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context2) {
        return this.filter != null ? this.filter.accepts(matchedNode) : DefaultFilter.accepts(patternNode, matchedNode);
    }

    public boolean matchSequentially(NodeIterator patternNodes, NodeIterator matchNodes, MatchContext context2) {
        MatchingStrategy strategy2 = context2.getPattern().getStrategy();
        PsiElement currentPatternNode = patternNodes.current();
        PsiElement currentMatchNode = matchNodes.current();
        MatchingHandler.skipIfNecessary(matchNodes, currentPatternNode, strategy2);
        MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy2);
        if (!patternNodes.hasNext()) {
            return !matchNodes.hasNext();
        }
        PsiElement patternElement = patternNodes.current();
        MatchingHandler handler = context2.getPattern().getHandler(patternElement);
        if (!(handler instanceof TopLevelMatchingHandler)) {
            MatchingHandler.skipComments(matchNodes, currentPatternNode);
        }
        if (matchNodes.hasNext() && handler.match(patternElement, matchNodes.current(), context2)) {
            patternNodes.advance();
            MatchingHandler.skipIfNecessary(patternNodes, matchNodes.current(), strategy2);
            if (this.shouldAdvanceTheMatchFor(patternElement, matchNodes.current())) {
                matchNodes.advance();
                MatchingHandler.skipIfNecessary(matchNodes, patternNodes.current(), strategy2);
                if (patternNodes.hasNext()) {
                    MatchingHandler.skipComments(matchNodes, patternNodes.current());
                }
            }
            if (patternNodes.hasNext()) {
                MatchingHandler nextHandler = context2.getPattern().getHandler(patternNodes.current());
                if (nextHandler.matchSequentially(patternNodes, matchNodes, context2)) {
                    return true;
                }
                patternNodes.rewindTo(currentPatternNode);
                matchNodes.rewindTo(currentMatchNode);
            } else {
                return handler.isMatchSequentiallySucceeded(matchNodes);
            }
        }
        return false;
    }

    private static void skipComments(NodeIterator matchNodes, PsiElement patternNode) {
        if (patternNode instanceof PsiComment) {
            return;
        }
        while (matchNodes.current() instanceof PsiComment) {
            matchNodes.advance();
        }
    }

    private static void skipIfNecessary(NodeIterator nodes, PsiElement elementToMatchWith, MatchingStrategy strategy2) {
        while (nodes.hasNext() && strategy2.shouldSkip(nodes.current(), elementToMatchWith)) {
            nodes.advance();
        }
    }

    protected boolean isMatchSequentiallySucceeded(NodeIterator matchNodes) {
        MatchingHandler.skipComments(matchNodes, null);
        return !matchNodes.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchInAnyOrder(NodeIterator patternNodes, NodeIterator matchedNodes, MatchContext context2) {
        MatchResultImpl saveResult = context2.hasResult() ? context2.getResult() : null;
        context2.setResult(null);
        try {
            if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
                boolean bl = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
                return bl;
            }
            HashSet<PsiElement> matchedElements = null;
            while (patternNodes.hasNext()) {
                PsiElement patternNode = patternNodes.current();
                patternNodes.advance();
                CompiledPattern pattern = context2.getPattern();
                MatchingHandler handler = pattern.getHandler(patternNode);
                matchedNodes.reset();
                boolean allElementsMatched = true;
                int matchedOccurs = 0;
                while (true) {
                    PsiElement pinnedNode;
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (pinnedNode = handler.getPinnedNode()) != null ? pinnedNode : matchedNodes.current();
                    if (pinnedNode == null) {
                        matchedNodes.advance();
                    }
                    if (matchedElements == null || !matchedElements.contains(matchedNode)) {
                        allElementsMatched = false;
                        if (handler.match(patternNode, matchedNode, context2)) {
                            ++matchedOccurs;
                            if (matchedElements == null) {
                                matchedElements = new HashSet<PsiElement>();
                            }
                            matchedElements.add(matchedNode);
                            if (handler.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                                break;
                            }
                        } else if (pinnedNode != null) {
                            boolean bl = false;
                            return bl;
                        }
                        clearingVisitor.clearState(pattern, patternNode);
                    }
                    if (matchedNodes.hasNext() && pinnedNode == null) continue;
                    if (!handler.validate(context2, matchedOccurs)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!allElementsMatched && patternNodes.hasNext()) break;
                    boolean result2 = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
                    if (result2 && matchedElements != null) {
                        context2.notifyMatchedElements(matchedElements);
                    }
                    boolean bl = result2;
                    return bl;
                }
                if (handler.validate(context2, matchedOccurs)) continue;
                boolean bl = false;
                return bl;
            }
            boolean result3 = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context2);
            if (result3 && matchedElements != null) {
                context2.notifyMatchedElements(matchedElements);
            }
            boolean bl = result3;
            return bl;
        }
        finally {
            if (saveResult != null) {
                if (context2.hasResult()) {
                    for (MatchResult child : context2.getResult().getChildren()) {
                        saveResult.addChild(child);
                    }
                }
                context2.setResult(saveResult);
            }
        }
    }

    protected static boolean validateSatisfactionOfHandlers(NodeIterator patternNodes, MatchContext context2) {
        while (patternNodes.hasNext()) {
            if (!context2.getPattern().getHandler(patternNodes.current()).validate(context2, 0)) {
                return false;
            }
            patternNodes.advance();
        }
        return true;
    }

    boolean validate(MatchContext context2, int matchedOccurs) {
        return matchedOccurs == 1;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public void reset() {
    }

    public PsiElement getPinnedNode() {
        return this.pinnedElement;
    }

    public void setPinnedElement(PsiElement pinnedElement) {
        this.pinnedElement = pinnedElement;
    }

    static class ClearStateVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private CompiledPattern pattern;

        ClearStateVisitor() {
            super(true);
        }

        public void visitElement(@NotNull PsiElement element) {
            MatchingHandler handler;
            if (this.pattern.isToResetHandler(element) && (handler = this.pattern.getHandlerSimple(element)) != null) {
                handler.reset();
            }
            super.visitElement(element);
        }

        synchronized void clearState(CompiledPattern _pattern, PsiElement el) {
            this.pattern = _pattern;
            el.acceptChildren((PsiElementVisitor)this);
            this.pattern = null;
        }
    }
}

