/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralWithSubstitutionHandler
extends MatchingHandler {
    private final String myRegexp;
    private Matcher myMatcher;
    private final List<? extends SubstitutionHandler> myHandlers;
    private final boolean myCaseSensitive;

    public LiteralWithSubstitutionHandler(String regexp, List<? extends SubstitutionHandler> handlers, boolean caseSensitive) {
        this.myRegexp = regexp;
        this.myHandlers = handlers;
        this.myCaseSensitive = caseSensitive;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context2) {
        return this.match(matchedNode, matchedNode.getText(), 0, context2);
    }

    public boolean match(PsiElement matchedNode, String text, int textOffset, MatchContext context2) {
        if (this.myMatcher == null) {
            this.myMatcher = Pattern.compile(this.myRegexp, (this.myCaseSensitive ? 0 : 2) | 0x20).matcher(text);
        } else {
            this.myMatcher.reset(text);
        }
        if (!this.myMatcher.matches()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myHandlers.size(); ++i2) {
            SubstitutionHandler handler = this.myHandlers.get(i2);
            if (handler.handle(matchedNode, textOffset + this.myMatcher.start(i2 + 1), textOffset + this.myMatcher.end(i2 + 1), context2)) continue;
            return false;
        }
        return true;
    }
}

