/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static LanguageFileType ourDefaultFileType = null;
    private static boolean ourUseUniversalMatchingAlgorithm = false;
    private static final Map<String, StructuralSearchProfile> cache = new HashMap<String, StructuralSearchProfile>();
    private static List<Configuration> ourPredefinedConfigurations = null;

    private StructuralSearchUtil() {
    }

    public static void setUseUniversalMatchingAlgorithm(boolean useUniversalMatchingAlgorithm) {
        ourUseUniversalMatchingAlgorithm = useUniversalMatchingAlgorithm;
        cache.clear();
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(LanguageFileType fileType) {
        return StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        String id = language.getID();
        if (cache.containsKey(id)) {
            return cache.get(id);
        }
        for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
            if (!profile.isMyLanguage(language)) continue;
            cache.put(id, profile);
            return profile;
        }
        cache.put(id, null);
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile != null && profile.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @Contract(value="!null -> !null")
    public static PsiElement getPresentableElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile == null ? element : profile.getPresentableElement(element);
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        SmartList list = new SmartList();
        for (StructuralSearchProfile profile : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
            if (!(profile instanceof StructuralSearchProfileBase)) continue;
            list.add(profile);
        }
        list.add(new XmlStructuralSearchProfile());
        return list.toArray(new StructuralSearchProfile[0]);
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    @NotNull
    public static LanguageFileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        return ourDefaultFileType;
    }

    public static boolean isTypedVariable(@NotNull String name) {
        return name.length() > 1 && name.charAt(0) == '$' && name.charAt(name.length() - 1) == '$';
    }

    public static LanguageFileType @NotNull [] getSuitableFileTypes() {
        Object[] types = FileTypeManager.getInstance().getRegisteredFileTypes();
        Set fileTypes = (Set)StreamEx.of((Object[])types).select(LanguageFileType.class).collect(Collectors.toSet());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            fileTypes.add(fileType);
        }
        return fileTypes.toArray(new LanguageFileType[0]);
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    public static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        return StructuralSearchUtil.shieldRegExpMetaChars(word, new StringBuilder(word.length())).toString();
    }

    public static String makeExtremeSpacesOptional(String word) {
        if (word.trim().isEmpty()) {
            return word;
        }
        String result2 = word;
        if (word.startsWith(" ")) {
            result2 = "(?:\\s|\\b)" + result2.substring(1);
        }
        if (word.endsWith(" ")) {
            result2 = result2.substring(0, result2.length() - 1) + "(?:\\s|\\b)";
        }
        return result2;
    }

    @NotNull
    public static StringBuilder shieldRegExpMetaChars(String word, StringBuilder out) {
        int length = word.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i2))) {
                out.append("\\");
            }
            out.append(word.charAt(i2));
        }
        return out;
    }

    public static Pattern[] createPatterns(String[] prefixes) {
        Pattern[] patterns = new Pattern[prefixes.length];
        for (int i2 = 0; i2 < prefixes.length; ++i2) {
            String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i2]);
            patterns[i2] = Pattern.compile("\\b(" + s + "\\w+)\\b");
        }
        return patterns;
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result2 = new ArrayList();
            for (StructuralSearchProfile profile : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result2, profile.getPredefinedTemplates());
            }
            Collections.sort(result2);
            ourPredefinedConfigurations = Collections.unmodifiableList(result2);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile != null && profile.isDocCommentOwner(match);
    }

    public static String getMeaningfulText(PsiElement matchedNode) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getMeaningfulText(matchedNode) : matchedNode.getText();
    }

    public static String getAlternativeText(PsiElement matchedNode, String previousText) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(matchedNode);
        return profile != null ? profile.getAlternativeText(matchedNode, previousText) : null;
    }

    public static String normalizeWhiteSpace(@NotNull String text) {
        text = text.trim();
        StringBuilder result2 = new StringBuilder();
        boolean white = false;
        int length = text.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c = text.charAt(i2);
            if (StringUtil.isWhiteSpace((char)c)) {
                if (white) continue;
                result2.append(' ');
                white = true;
                continue;
            }
            white = false;
            result2.append(c);
        }
        return result2.toString();
    }

    public static String stripAccents(@NotNull String input) {
        return ACCENTS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
    }

    public static String normalize(@NotNull String text) {
        return StructuralSearchUtil.stripAccents(StructuralSearchUtil.normalizeWhiteSpace(text));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @NotNull Language language) {
        return StructuralSearchUtil.findPatternContextByID(id, StructuralSearchUtil.getProfileByLanguage(language));
    }

    public static PatternContext findPatternContextByID(@Nullable String id, @Nullable StructuralSearchProfile profile) {
        if (profile == null) {
            return null;
        }
        List<PatternContext> patternContexts = profile.getPatternContexts();
        if (patternContexts.isEmpty()) {
            return null;
        }
        if (id == null) {
            return patternContexts.get(0);
        }
        return patternContexts.stream().filter(context2 -> context2.getId().equals(id)).findFirst().orElse(patternContexts.get(0));
    }

    static {
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> {
            ourPredefinedConfigurations = null;
            ourDefaultFileType = null;
            cache.clear();
        }, null);
    }
}

