/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scopes {
    private Scopes() {
    }

    public static Type getType(@Nullable SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return Type.PROJECT;
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return Type.MODULE;
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            return Type.DIRECTORY;
        }
        return Type.NAMED;
    }

    public static String getDescriptor(SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return "";
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return ((ModuleWithDependenciesScope)scope).getModule().getName();
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            String url = directoryScope.getDirectory().getPresentableUrl();
            return directoryScope.isWithSubdirectories() ? "*" + url : url;
        }
        return scope.getDisplayName();
    }

    public static SearchScope createScope(@NotNull Project project2, @NotNull String descriptor, @NotNull Type scopeType) {
        if (scopeType == Type.PROJECT) {
            return GlobalSearchScope.projectScope((Project)project2);
        }
        if (scopeType == Type.MODULE) {
            Module module2 = ModuleManager.getInstance((Project)project2).findModuleByName(descriptor);
            if (module2 != null) {
                return GlobalSearchScope.moduleScope((Module)module2);
            }
        } else {
            if (scopeType == Type.DIRECTORY) {
                boolean recursive = StringUtil.startsWithChar((CharSequence)descriptor, (char)'*');
                if (recursive) {
                    descriptor = descriptor.substring(1);
                }
                String path = FileUtil.toSystemIndependentName((String)descriptor.substring(1));
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
                if (virtualFile == null) {
                    return null;
                }
                return new GlobalSearchScopesCore.DirectoryScope(project2, virtualFile, recursive);
            }
            if (scopeType == Type.NAMED) {
                return Scopes.findScopeByName(project2, descriptor);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static SearchScope findScopeByName(@NotNull Project project2, @NotNull String scopeName) {
        List predefinedScopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project2, null, true, false, true, true, true);
        for (SearchScope predefinedScope : predefinedScopes) {
            if (!predefinedScope.getDisplayName().equals(scopeName)) continue;
            return predefinedScope;
        }
        for (FindInProjectExtension extension : FindInProjectExtension.EP_NAME.getExtensionList()) {
            for (NamedScope scope : extension.getFilteredNamedScopes(project2)) {
                if (!scope.getName().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)scope);
            }
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project2)) {
            for (NamedScope scope : holder.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)scope);
            }
        }
        return null;
    }

    public static enum Type {
        PROJECT,
        MODULE,
        DIRECTORY,
        NAMED;

    }
}

