/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.util.JDOMExternalizable;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class NamedScriptableDefinition
implements JDOMExternalizable {
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String SCRIPT = "script";
    private String name;
    private String scriptCodeConstraint;

    public NamedScriptableDefinition() {
        this.name = "";
        this.scriptCodeConstraint = "";
    }

    NamedScriptableDefinition(NamedScriptableDefinition definition) {
        this.name = definition.name;
        this.scriptCodeConstraint = definition.scriptCodeConstraint;
    }

    public abstract NamedScriptableDefinition copy();

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getScriptCodeConstraint() {
        return this.scriptCodeConstraint;
    }

    public void setScriptCodeConstraint(@NotNull String scriptCodeConstraint) {
        this.scriptCodeConstraint = "\"\"".equals(scriptCodeConstraint) ? "" : scriptCodeConstraint;
    }

    public void readExternal(Element element) {
        Attribute attribute = element.getAttribute(NAME);
        this.name = attribute != null ? attribute.getValue() : "";
        String script = element.getAttributeValue(SCRIPT);
        this.scriptCodeConstraint = script != null ? script : "";
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME, this.name);
        if (!this.scriptCodeConstraint.isEmpty()) {
            element.setAttribute(SCRIPT, this.scriptCodeConstraint);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedScriptableDefinition)) {
            return false;
        }
        NamedScriptableDefinition that = (NamedScriptableDefinition)o;
        return this.name.equals(that.name) && this.scriptCodeConstraint.equals(that.scriptCodeConstraint);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.scriptCodeConstraint.hashCode();
    }
}

