/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.FoldingHandler;
import com.intellij.psi.codeStyle.arrangement.FoldingInfo;
import com.intellij.psi.codeStyle.arrangement.Info;
import com.intellij.psi.codeStyle.arrangement.RangeHandler;
import com.intellij.psi.codeStyle.arrangement.RichTextHandler;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRearrangerTest
extends BasePlatformTestCase {
    private static final RichTextHandler[] RICH_TEXT_HANDLERS = new RichTextHandler[]{new RangeHandler(), new FoldingHandler()};
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([^\\s]+)=([^\\s]+)");
    protected FileType fileType;
    protected Language language;

    @NotNull
    protected CommonCodeStyleSettings getCommonSettings() {
        return CodeStyle.getSettings((Project)this.myFixture.getProject()).getCommonSettings(this.language);
    }

    protected static ArrangementSectionRule section(StdArrangementMatchRule ... rules) {
        return AbstractRearrangerTest.section(null, null, rules);
    }

    protected static ArrangementSectionRule section(@Nullable String start, @Nullable String end, StdArrangementMatchRule ... rules) {
        return ArrangementSectionRule.create((String)start, (String)end, (StdArrangementMatchRule[])rules);
    }

    protected static StdArrangementRuleAliasToken alias(@NotNull String id, StdArrangementMatchRule ... rules) {
        return new StdArrangementRuleAliasToken(id, id, (List)ContainerUtil.newArrayList((Object[])rules));
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type) {
        return AbstractRearrangerTest.group(type, StdArrangementTokens.Order.KEEP);
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken type, @NotNull ArrangementSettingsToken order) {
        return new ArrangementGroupingRule(type, order);
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull ArrangementSettingsToken token) {
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(token)));
    }

    @NotNull
    protected static StdArrangementMatchRule nameRule(@NotNull String nameFilter, ArrangementSettingsToken ... tokens) {
        if (tokens.length == 0) {
            return new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(nameFilter)));
        }
        ArrangementAtomMatchCondition[] conditions = new ArrangementAtomMatchCondition[tokens.length + 1];
        conditions[0] = AbstractRearrangerTest.atom(nameFilter);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            conditions[i2 + 1] = AbstractRearrangerTest.atom(tokens[i2]);
        }
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementSettingsToken ... conditions) {
        return AbstractRearrangerTest.rule(ContainerUtil.map((Object[])conditions, it -> AbstractRearrangerTest.atom(it)));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull List<ArrangementAtomMatchCondition> conditions) {
        return AbstractRearrangerTest.rule(conditions.toArray(new ArrangementAtomMatchCondition[0]));
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementAtomMatchCondition ... conditions) {
        ArrangementMatchCondition compositeCondition = ArrangementUtil.combine((ArrangementMatchCondition[])conditions);
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(compositeCondition));
    }

    @NotNull
    protected static StdArrangementMatchRule ruleWithOrder(@NotNull ArrangementSettingsToken orderType, @NotNull StdArrangementMatchRule rule2) {
        return new StdArrangementMatchRule(rule2.getMatcher(), orderType);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token) {
        return new ArrangementAtomMatchCondition(token);
    }

    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken token, boolean included) {
        return new ArrangementAtomMatchCondition(token, (Object)included);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull String nameFilter) {
        return new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)nameFilter);
    }

    protected void doTest(@NotNull Map<String, ?> args) {
        List groupingRules = (List)ObjectUtils.coalesce((Object)((List)args.get("groups")), Collections.emptyList());
        List rules = (List)args.get("rules");
        List<ArrangementSectionRule> sectionRules = this.getSectionRules(rules);
        List aliases = (List)ObjectUtils.coalesce((Object)((List)args.get("aliases")), Collections.emptyList());
        StdArrangementExtendableSettings arrangementSettings = new StdArrangementExtendableSettings(groupingRules, sectionRules, (Collection)aliases);
        String text = (String)args.get("initial");
        String expected = (String)args.get("expected");
        List ranges = (List)args.get("ranges");
        this.doTestWithSettings(text, expected, (ArrangementSettings)arrangementSettings, ranges);
    }

    protected void doTestWithSettings(@NotNull String text, @NotNull String expected, @Nullable ArrangementSettings arrangementSettings, @Nullable List<TextRange> ranges) {
        Info info = AbstractRearrangerTest.parse(text);
        if (!AbstractRearrangerTest.isEmpty(ranges) && !AbstractRearrangerTest.isEmpty(info.ranges)) {
            AbstractRearrangerTest.fail((String)("Duplicate ranges set: explicit: " + ranges + ", derived: " + info.ranges + ", text:\n" + text));
        }
        if (AbstractRearrangerTest.isEmpty(info.ranges)) {
            info.ranges = !AbstractRearrangerTest.isEmpty(ranges) ? ranges : Collections.singletonList(TextRange.from((int)0, (int)text.length()));
        }
        this.myFixture.configureByText(this.fileType, info.text);
        FoldingModel foldingModel = this.myFixture.getEditor().getFoldingModel();
        for (FoldingInfo foldingInfo : info.foldings) {
            foldingModel.runBatchFoldingOperation(() -> {
                FoldRegion region2 = foldingModel.addFoldRegion(foldingInfo.start, foldingInfo.end, foldingInfo.placeholder);
                if (region2 != null) {
                    region2.setExpanded(false);
                }
            });
        }
        if (arrangementSettings != null) {
            CommonCodeStyleSettings settings = CodeStyle.getSettings((Project)this.myFixture.getProject()).getCommonSettings(this.language);
            settings.setArrangementSettings(arrangementSettings);
        }
        ArrangementEngine engine = ArrangementEngine.getInstance();
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> engine.arrange(this.myFixture.getEditor(), this.myFixture.getFile(), info.ranges), null, null);
        Info after2 = AbstractRearrangerTest.parse(expected);
        AbstractRearrangerTest.assertEquals((String)after2.text, (String)this.myFixture.getEditor().getDocument().getText());
        for (FoldingInfo it : after2.foldings) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(it.start);
            AbstractRearrangerTest.assertNotNull((String)("Expected to find fold region at offset " + it.start), (Object)foldRegion);
            AbstractRearrangerTest.assertEquals((int)it.end, (int)foldRegion.getEndOffset());
        }
    }

    @NotNull
    protected List<ArrangementSectionRule> getSectionRules(@Nullable List<?> rules) {
        if (rules == null) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.map(rules, o -> o instanceof ArrangementSectionRule ? (ArrangementSectionRule)o : ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)o}));
    }

    private static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    private static Info parse(@NotNull String text) {
        Info result2 = new Info();
        StringBuilder buffer = new StringBuilder(text);
        int offset = 0;
        while (offset < buffer.length()) {
            RichTextHandler handler = null;
            int richTextMarkStart = -1;
            for (RichTextHandler h : RICH_TEXT_HANDLERS) {
                int i2 = buffer.indexOf("<" + h.getMarker(), offset);
                if (i2 < 0 || handler != null && i2 >= richTextMarkStart) continue;
                richTextMarkStart = i2;
                handler = h;
            }
            if (handler == null) break;
            String marker = handler.getMarker();
            int attrStart = richTextMarkStart + marker.length() + 1;
            int openingTagEnd = buffer.indexOf(">", richTextMarkStart);
            int openTagLength = openingTagEnd - richTextMarkStart + 1;
            Map<String, String> attributes = AbstractRearrangerTest.parseAttributes(buffer.substring(attrStart, openingTagEnd));
            String closingTag = "</" + marker + ">";
            int closingTagStart = buffer.indexOf(closingTag);
            assert (closingTagStart > 0);
            handler.handle(result2, attributes, richTextMarkStart, closingTagStart - openTagLength);
            buffer.delete(closingTagStart, closingTagStart + closingTag.length());
            buffer.delete(richTextMarkStart, openingTagEnd + 1);
            offset = closingTagStart - openTagLength;
        }
        result2.text = buffer.toString();
        return result2;
    }

    @NotNull
    private static Map<String, String> parseAttributes(@NotNull String text) {
        if (text.isEmpty()) {
            return Collections.emptyMap();
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(text);
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            result2.put(matcher.group(1), matcher.group(2));
        }
        return result2;
    }
}

