/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger LOG = Logger.getInstance(DuplocatorHashCallback.class);
    private TIntObjectHashMap<List<List<PsiFragment>>> myDuplicates = new TIntObjectHashMap();
    private final int myBound;
    private boolean myReadOnly = false;
    private final int myDiscardCost;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.myBound = bound;
        this.myDiscardCost = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.myReadOnly = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public void add(int hash, int cost, PsiFragment frag, NodeSpecificHasher visitor) {
        this.forceAdd(hash, cost, frag);
    }

    private void forceAdd(int hash, int cost, PsiFragment frag) {
        if (frag == null) {
            this.myDuplicates.put(hash, new ArrayList());
            return;
        }
        frag.setCost(cost);
        List fragments = (List)this.myDuplicates.get(hash);
        if (fragments == null) {
            if (!this.myReadOnly) {
                ArrayList list = new ArrayList();
                ArrayList<PsiFragment> listf = new ArrayList<PsiFragment>();
                listf.add(frag);
                list.add(listf);
                this.myDuplicates.put(hash, list);
            }
            return;
        }
        boolean found2 = false;
        PsiElement[] elements = frag.getElements();
        int discardCost = 0;
        if (this.myDiscardCost >= 0) {
            discardCost = this.myDiscardCost;
        } else {
            DuplocatorState state = DuplocatorUtil.getDuplocatorState(frag);
            if (state != null) {
                discardCost = state.getDiscardCost();
            }
        }
        Iterator i2 = fragments.iterator();
        while (i2.hasNext() && !found2) {
            List fi = (List)i2.next();
            PsiFragment aFrag = (PsiFragment)fi.get(0);
            if (!aFrag.isEqual(elements, discardCost)) continue;
            boolean skipNew = false;
            Iterator frags = fi.iterator();
            while (frags.hasNext() && !skipNew) {
                PsiFragment old = (PsiFragment)frags.next();
                if (!frag.intersectsWith(old)) continue;
                if (old.getCost() < frag.getCost() || frag.contains(old)) {
                    frags.remove();
                    continue;
                }
                skipNew = true;
            }
            if (!skipNew) {
                fi.add(frag);
            }
            found2 = true;
        }
        if (!found2) {
            ArrayList<PsiFragment> newFrags = new ArrayList<PsiFragment>();
            newFrags.add(frag);
            fragments.add(newFrags);
        }
    }

    @Override
    public void add(int hash, int cost, PsiFragment frag) {
        int bound;
        if (this.myBound >= 0) {
            bound = this.myBound;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            bound = duplocatorState.getLowerBound();
        }
        if (cost >= bound) {
            this.forceAdd(hash, cost, frag);
        }
    }

    public DupInfo getInfo() {
        final Object2IntOpenHashMap duplicateList = new Object2IntOpenHashMap();
        this.myDuplicates.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<List<PsiFragment>>>(){

            public boolean execute(int hash, List<List<PsiFragment>> listList) {
                for (List<PsiFragment> list : listList) {
                    int len = list.size();
                    if (len <= 1) continue;
                    PsiFragment[] filtered = new PsiFragment[len];
                    int idx = 0;
                    for (PsiFragment fragment : list) {
                        fragment.markDuplicate();
                        filtered[idx++] = fragment;
                    }
                    duplicateList.put((Object)filtered, hash);
                }
                return true;
            }
        });
        this.myDuplicates = null;
        ObjectIterator iterator2 = duplicateList.object2IntEntrySet().fastIterator();
        while (iterator2.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator2.next();
            PsiFragment[] fragments = (PsiFragment[])entry.getKey();
            LOG.assertTrue(fragments.length > 1);
            boolean nested = false;
            for (PsiFragment fragment : fragments) {
                if (!fragment.isNested()) continue;
                nested = true;
                break;
            }
            if (!nested) continue;
            iterator2.remove();
        }
        final PsiFragment[][] duplicates = (PsiFragment[][])duplicateList.keySet().toArray((Object[])new PsiFragment[0][]);
        Arrays.sort(duplicates, (x, y) -> y[0].getCost() - x[0].getCost());
        return new DupInfo(){
            private final TIntObjectHashMap<GroupNodeDescription> myPattern2Description = new TIntObjectHashMap();

            @Override
            public int getPatterns() {
                return duplicates.length;
            }

            @Override
            public int getPatternCost(int number) {
                return duplicates[number][0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return duplicates[number].length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return duplicates[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] occs = this.getFragmentOccurences(pattern);
                UsageInfo[] infos = new UsageInfo[occs.length];
                for (int i2 = 0; i2 < infos.length; ++i2) {
                    infos[i2] = occs[i2].getUsageInfo();
                }
                return infos;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.myPattern2Description.containsKey(pattern)) {
                    return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getFilesCount();
                }
                return this.cacheGroupNodeDescription(pattern).getFilesCount();
            }

            private GroupNodeDescription cacheGroupNodeDescription(int pattern) {
                PsiFragment[] occurencies;
                HashSet<PsiFile> files = new HashSet<PsiFile>();
                for (PsiFragment occurency : occurencies = this.getFragmentOccurences(pattern)) {
                    PsiFile file2 = occurency.getFile();
                    if (file2 == null) continue;
                    files.add(file2);
                }
                int fileCount = files.size();
                PsiFile psiFile = occurencies[0].getFile();
                DuplicatesProfile profile = DuplicatesProfile.findProfileForDuplicate(this, pattern);
                String comment = profile != null ? profile.getComment(this, pattern) : "";
                GroupNodeDescription description2 = new GroupNodeDescription(fileCount, psiFile != null ? psiFile.getName() : "unknown", comment);
                this.myPattern2Description.put(pattern, (Object)description2);
                return description2;
            }

            @Override
            @Nullable
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getTitle();
                    }
                    return this.cacheGroupNodeDescription(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getComment();
                    }
                    return this.cacheGroupNodeDescription(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i2) {
                return duplicateList.getInt((Object)duplicates[i2]);
            }
        };
    }

    public void report(@NotNull Path dir, @NotNull Project project2) throws IOException {
        int[] hashCodes = this.myDuplicates.keys();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(dir.resolve("fragments.xml"), new OpenOption[0]);){
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            for (int hash : hashCodes) {
                List dupList = (List)this.myDuplicates.get(hash);
                writer.startNode("hash");
                writer.addAttribute("val", String.valueOf(hash));
                for (List psiFragments : dupList) {
                    DuplocatorHashCallback.writeFragments(psiFragments, (HierarchicalStreamWriter)writer, project2, false);
                }
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
        DuplocatorHashCallback.writeDuplicates(dir, project2, this.getInfo());
    }

    public static void writeDuplicates(@NotNull Path dir, @NotNull Project project2, DupInfo info) throws IOException {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(dir.resolve("duplicates.xml"), new OpenOption[0]);){
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            int patterns = info.getPatterns();
            for (int i2 = 0; i2 < patterns; ++i2) {
                writer.startNode("duplicate");
                writer.addAttribute("cost", String.valueOf(info.getPatternCost(i2)));
                writer.addAttribute("hash", String.valueOf(info.getHash(i2)));
                DuplocatorHashCallback.writeFragments(Arrays.asList(info.getFragmentOccurences(i2)), (HierarchicalStreamWriter)writer, project2, true);
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
    }

    private static void writeFragments(List<? extends PsiFragment> psiFragments, HierarchicalStreamWriter writer, @NotNull Project project2, boolean shouldWriteOffsets) {
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project2);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        for (PsiFragment psiFragment : psiFragments) {
            PsiFile psiFile = psiFragment.getFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) continue;
            writer.startNode("fragment");
            writer.addAttribute("file", macroManager.collapsePath(virtualFile.getUrl()));
            if (shouldWriteOffsets) {
                Document document2 = documentManager.getDocument(psiFile);
                LOG.assertTrue(document2 != null);
                int startOffset = psiFragment.getStartOffset();
                int line = document2.getLineNumber(startOffset);
                writer.addAttribute("line", String.valueOf(line));
                int lineStartOffset = document2.getLineStartOffset(line);
                if (StringUtil.isEmptyOrSpaces((String)document2.getText().substring(lineStartOffset, startOffset))) {
                    startOffset = lineStartOffset;
                }
                writer.addAttribute("start", String.valueOf(startOffset));
                writer.addAttribute("end", String.valueOf(psiFragment.getEndOffset()));
                if (psiFragment.containsMultipleFragments()) {
                    int[][] offsets;
                    for (int[] offset : offsets = psiFragment.getOffsets()) {
                        writer.startNode("offset");
                        writer.addAttribute("start", String.valueOf(offset[0]));
                        writer.addAttribute("end", String.valueOf(offset[1]));
                        writer.endNode();
                    }
                }
            }
            writer.endNode();
        }
    }
}

