/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    public boolean myFilterOutGeneratedCode;
    private static final int MIN_FRAGMENT_SIZE = 3;

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager2, boolean isOnTheFly) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (!(virtualFile instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (profile == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        FileASTNode node2 = psiFile.getNode();
        boolean usingLightProfile = profile instanceof LightDuplicateProfile && node2.getElementType() instanceof ILightStubFileElementType;
        Project project2 = psiFile.getProject();
        DuplicatedCodeProcessor<?> processor2 = usingLightProfile ? this.processLightDuplicates(node2, virtualFile, (LightDuplicateProfile)((Object)profile), project2) : this.processPsiDuplicates(psiFile, virtualFile, profile, project2);
        if (processor2 == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        VirtualFile baseDir = project2.getBaseDir();
        for (Int2ObjectMap.Entry entry : processor2.reportedRanges.int2ObjectEntrySet()) {
            LocalQuickFix extractMethodFix;
            int offset = entry.getIntKey();
            if (!usingLightProfile && processor2.fragmentSize.get(offset) < 3) continue;
            VirtualFile file2 = (VirtualFile)processor2.reportedFiles.get(offset);
            String path = null;
            if (file2.equals(virtualFile)) {
                path = "this file";
            } else if (baseDir != null) {
                path = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)baseDir);
            }
            if (path == null) {
                path = file2.getPath();
            }
            String message = DupLocatorBundle.message("inspection.message.found.duplicated.code.in", path);
            PsiElement targetElement = (PsiElement)processor2.reportedPsi.get(offset);
            TextRange rangeInElement = (TextRange)entry.getValue();
            int offsetInOtherFile = processor2.reportedOffsetInOtherFiles.get(offset);
            LocalQuickFix fix = isOnTheFly ? this.createNavigateToDupeFix(file2, offsetInOtherFile) : null;
            long hash = processor2.fragmentHash.get(offset);
            int hash2 = (int)(hash >> 32);
            LocalQuickFix viewAllDupesFix = isOnTheFly && hash != 0L ? this.createShowOtherDupesFix(virtualFile, offset, (int)hash, hash2) : null;
            boolean onlyExtractable = Registry.is((String)"duplicates.inspection.only.extractable");
            LocalQuickFix localQuickFix = extractMethodFix = (isOnTheFly || onlyExtractable) && hash != 0L ? this.createExtractMethodFix(targetElement, rangeInElement, (int)hash, hash2) : null;
            if (onlyExtractable) {
                if (extractMethodFix == null) {
                    return null;
                }
                if (!isOnTheFly) {
                    extractMethodFix = null;
                }
            }
            ProblemDescriptor descriptor = manager2.createProblemDescriptor(targetElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{fix, viewAllDupesFix, extractMethodFix});
            descriptors.add((Object)descriptor);
        }
        return descriptors.isEmpty() ? null : (ProblemDescriptor[])descriptors.toArray((Object[])ProblemDescriptor.EMPTY_ARRAY);
    }

    private DuplicatedCodeProcessor<?> processLightDuplicates(FileASTNode node2, VirtualFile virtualFile, LightDuplicateProfile profile, Project project2) {
        Ref processorRef = new Ref();
        LighterAST lighterAST = node2.getLighterAST();
        profile.process(lighterAST, (hash, hash2, ast, nodes) -> {
            DuplicatedCodeProcessor processor2 = (DuplicatedCodeProcessor)processorRef.get();
            if (processor2 == null) {
                processor2 = new LightDuplicatedCodeProcessor((TreeBackedLighterAST)ast, virtualFile, project2);
                processorRef.set((Object)processor2);
            }
            processor2.process(hash, hash2, nodes[0]);
        });
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    private DuplicatedCodeProcessor<?> processPsiDuplicates(PsiFile psiFile, VirtualFile virtualFile, DuplicatesProfile profile, Project project2) {
        DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
        Ref processorRef = new Ref();
        DuplocateVisitor visitor = profile.createVisitor((hash, cost, frag) -> {
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, profile, state)) {
                return;
            }
            DuplicatedCodeProcessor processor2 = (DuplicatedCodeProcessor)processorRef.get();
            if (processor2 == null) {
                processor2 = new OldDuplicatedCodeProcessor(virtualFile, project2);
                processorRef.set((Object)processor2);
            }
            processor2.process(hash, 0, frag);
        }, true);
        visitor.visitNode((PsiElement)psiFile);
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file2, int offsetInOtherFile) {
        return null;
    }

    protected LocalQuickFix createShowOtherDupesFix(VirtualFile file2, int offset, int hash, int hash2) {
        return null;
    }

    protected LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        return null;
    }

    static abstract class DuplicatedCodeProcessor<T>
    implements FileBasedIndex.ValueProcessor<IntArrayList> {
        final Int2ObjectRBTreeMap<TextRange> reportedRanges = new Int2ObjectRBTreeMap();
        final Int2ObjectOpenHashMap<VirtualFile> reportedFiles = new Int2ObjectOpenHashMap();
        final Int2ObjectOpenHashMap<PsiElement> reportedPsi = new Int2ObjectOpenHashMap();
        final Int2IntOpenHashMap reportedOffsetInOtherFiles = new Int2IntOpenHashMap();
        final Int2IntOpenHashMap fragmentSize = new Int2IntOpenHashMap();
        final Int2LongOpenHashMap fragmentHash = new Int2LongOpenHashMap();
        final VirtualFile virtualFile;
        final Project project;
        final FileIndex myFileIndex;
        final boolean mySkipGeneratedCode;
        final boolean myFileWithinGeneratedCode;
        T myNode;
        int myHash;
        int myHash2;

        DuplicatedCodeProcessor(VirtualFile file2, Project project2, boolean skipGeneratedCode) {
            this.virtualFile = file2;
            this.project = project2;
            this.myFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            this.mySkipGeneratedCode = skipGeneratedCode;
            this.myFileWithinGeneratedCode = skipGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project2);
        }

        void process(int hash, int hash2, T node2) {
            ProgressManager.checkCanceled();
            this.myNode = node2;
            this.myHash = hash;
            this.myHash2 = hash2;
            FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, (Object)hash, null, (FileBasedIndex.ValueProcessor)this, GlobalSearchScope.projectScope((Project)this.project));
        }

        public boolean process(@NotNull VirtualFile file2, IntArrayList list) {
            int len = list.size();
            for (int i2 = 0; i2 < len; i2 += 2) {
                ProgressManager.checkCanceled();
                if (list.getInt(i2 + 1) != this.myHash2) continue;
                int offset = list.getInt(i2);
                if (this.myFileIndex.isInSourceContent(this.virtualFile)) {
                    if (!this.myFileIndex.isInSourceContent(file2)) {
                        return true;
                    }
                    if (!TestSourcesFilter.isTestSources((VirtualFile)this.virtualFile, (Project)this.project) && TestSourcesFilter.isTestSources((VirtualFile)file2, (Project)this.project)) {
                        return true;
                    }
                    if (this.mySkipGeneratedCode && !this.myFileWithinGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)this.project)) {
                        return true;
                    }
                } else if (this.myFileIndex.isInSourceContent(file2)) {
                    return true;
                }
                int startOffset = this.getStartOffset(this.myNode);
                int endOffset = this.getEndOffset(this.myNode);
                if (file2.equals(this.virtualFile) && offset >= startOffset && offset < endOffset) continue;
                PsiElement target = this.getPsi(this.myNode);
                TextRange rangeInElement = this.getRangeInElement(this.myNode);
                int fragmentStartOffsetInteger = startOffset;
                Int2ObjectSortedMap map2 = this.reportedRanges.subMap(fragmentStartOffsetInteger, endOffset);
                int newFragmentSize = !map2.isEmpty() ? 0 : 1;
                IntBidirectionalIterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    int next = iterator2.nextInt();
                    iterator2.remove();
                    this.reportedFiles.remove(next);
                    this.reportedOffsetInOtherFiles.remove(next);
                    this.reportedPsi.remove(next);
                    newFragmentSize += this.fragmentSize.remove(next);
                }
                this.reportedRanges.put(fragmentStartOffsetInteger, (Object)rangeInElement);
                this.reportedFiles.put(fragmentStartOffsetInteger, (Object)file2);
                this.reportedOffsetInOtherFiles.put(fragmentStartOffsetInteger, offset);
                this.reportedPsi.put(fragmentStartOffsetInteger, (Object)target);
                this.fragmentSize.put(fragmentStartOffsetInteger, newFragmentSize);
                if (newFragmentSize >= 3 || this.isLightProfile()) {
                    this.fragmentHash.put(fragmentStartOffsetInteger, (long)this.myHash & 0xFFFFFFFFL | (long)this.myHash2 << 32);
                }
                return false;
            }
            return true;
        }

        protected abstract TextRange getRangeInElement(T var1);

        protected abstract PsiElement getPsi(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getEndOffset(T var1);

        protected abstract boolean isLightProfile();
    }

    final class OldDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<PsiFragment> {
        private OldDuplicatedCodeProcessor(VirtualFile file2, Project project2) {
            super(file2, project2, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
        }

        @Override
        protected TextRange getRangeInElement(PsiFragment node2) {
            PsiElement[] elements = node2.getElements();
            TextRange rangeInElement = null;
            if (elements.length > 1) {
                PsiElement lastElement = elements[elements.length - 1];
                rangeInElement = new TextRange(elements[0].getStartOffsetInParent(), lastElement.getStartOffsetInParent() + lastElement.getTextLength());
            }
            return rangeInElement;
        }

        @Override
        protected PsiElement getPsi(PsiFragment node2) {
            PsiElement[] elements = node2.getElements();
            return elements.length > 1 ? elements[0].getParent() : elements[0];
        }

        @Override
        protected int getStartOffset(PsiFragment node2) {
            return node2.getStartOffset();
        }

        @Override
        protected int getEndOffset(PsiFragment node2) {
            return node2.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return false;
        }
    }

    private final class LightDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<LighterASTNode> {
        private final TreeBackedLighterAST myAst;

        private LightDuplicatedCodeProcessor(TreeBackedLighterAST ast, VirtualFile file2, Project project2) {
            super(file2, project2, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
            this.myAst = ast;
        }

        @Override
        protected TextRange getRangeInElement(LighterASTNode node2) {
            return null;
        }

        @Override
        protected PsiElement getPsi(LighterASTNode node2) {
            return this.myAst.unwrap(node2).getPsi();
        }

        @Override
        protected int getStartOffset(LighterASTNode node2) {
            return node2.getStartOffset();
        }

        @Override
        protected int getEndOffset(LighterASTNode node2) {
            return node2.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return true;
        }
    }
}

