/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement>,
DumbAware {
    protected final String myPopupTitle;
    private final String myEmptyText;
    protected final Computable<? extends PsiElementListCellRenderer> myCellRenderer;
    private final NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> myPointers;

    protected NavigationGutterIconRenderer(String popupTitle, String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers2) {
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers2;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @NotNull
    public List<PsiElement> getTargetElements() {
        List pointers2 = (List)this.myPointers.getValue();
        if (pointers2.isEmpty()) {
            return Collections.emptyList();
        }
        Project project2 = ((SmartPsiElementPointer)pointers2.get(0)).getProject();
        DumbService dumbService = DumbService.getInstance((Project)project2);
        return (List)dumbService.computeWithAlternativeResolveEnabled(() -> ContainerUtil.mapNotNull((Collection)pointers2, smartPsiElementPointer -> smartPsiElementPointer.getElement()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer = (NavigationGutterIconRenderer)((Object)o);
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer.myEmptyText) : renderer.myEmptyText != null) {
            return false;
        }
        if (!((List)this.myPointers.getValue()).equals(renderer.myPointers.getValue())) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer.myPopupTitle) : renderer.myPopupTitle != null);
    }

    public int hashCode() {
        int result2 = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result2 = 31 * result2 + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result2 = 31 * result2 + ((List)this.myPointers.getValue()).hashCode();
        return result2;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                NavigationGutterIconRenderer.this.navigate((MouseEvent)e.getInputEvent(), null);
            }
        };
    }

    public void navigate(@Nullable MouseEvent event, @Nullable PsiElement elt) {
        List<PsiElement> list = this.getTargetElements();
        if (list.isEmpty()) {
            if (this.myEmptyText != null && event != null) {
                JComponent label = HintUtil.createErrorLabel((String)this.myEmptyText);
                label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7, (int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(event), Balloon.Position.above);
            }
        } else {
            this.navigateToItems(event);
        }
    }

    protected void navigateToItems(@Nullable MouseEvent event) {
        ArrayList navigatables = new ArrayList();
        for (SmartPsiElementPointer pointer : (List)this.myPointers.getValue()) {
            ContainerUtil.addIfNotNull(navigatables, (Object)NavigationGutterIconRenderer.getNavigatable(pointer));
        }
        if (navigatables.size() == 1) {
            ((Navigatable)navigatables.get(0)).navigate(true);
        } else if (event != null) {
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(this.getTargetElements());
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)((PsiElementListCellRenderer)this.myCellRenderer.compute()), (String)this.myPopupTitle);
            popup.show(new RelativePoint(event));
        }
    }

    @Nullable
    private static Navigatable getNavigatable(SmartPsiElementPointer<?> pointer) {
        Navigatable element = NavigationGutterIconRenderer.getNavigationElement(pointer);
        if (element != null) {
            return element;
        }
        VirtualFile virtualFile = pointer.getVirtualFile();
        Segment actualRange = pointer.getRange();
        if (virtualFile != null && actualRange != null && virtualFile.isValid() && actualRange.getStartOffset() >= 0) {
            return new OpenFileDescriptor(pointer.getProject(), virtualFile, actualRange.getStartOffset());
        }
        return null;
    }

    @Nullable
    private static Navigatable getNavigationElement(SmartPsiElementPointer<?> pointer) {
        PsiElement element = pointer.getElement();
        if (element == null) {
            return null;
        }
        PsiElement navigationElement = element.getNavigationElement();
        return navigationElement instanceof Navigatable ? (Navigatable)navigationElement : null;
    }
}

