/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BooleanFunction;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.KotlinGradleModel;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilder;
import org.jetbrains.kotlin.gradle.KotlinGradleModelBuilderKt;
import org.jetbrains.kotlin.gradle.KotlinMPPGradleModel;
import org.jetbrains.kotlin.gradle.KotlinTarget;
import org.jetbrains.kotlin.gradle.KotlinTaskProperties;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPGradleProjectResolverKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacadeKt;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.idea.statistics.KotlinGradleFUSLogger;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0002J4\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0002J.\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000bH\u0002Jh\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2 \u0010$\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020'0&\u0018\u00010%2&\u0010(\u001a\"\u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\f\u0012\u0004\u0012\u00020)0&\u0018\u00010%H\u0002J\u0016\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,0+H\u0016J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020-0,0+H\u0016J\u001e\u0010/\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J,\u00100\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0016J\b\u00101\u001a\u000202H\u0002J0\u00103\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\"*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fH\u0002JD\u00104\u001a4\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012(\u0012&\u0012\f\u0012\n 5*\u0004\u0018\u00010 0  5*\u0012\u0012\f\u0012\n 5*\u0004\u0018\u00010 0 \u0018\u00010\f0\f0%*\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\r\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\"\u0010\n\u001a\u0004\u0018\u00010\u000b*\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleProjectResolverExtension;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isAndroidProjectKey", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/annotations/Nullable;", "()Lcom/intellij/openapi/util/Key;", "sourceSetName", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getSourceSetName", "(Lcom/intellij/openapi/externalSystem/model/DataNode;)Ljava/lang/String;", "addDependency", "", "ideModule", "targetModule", "addImplementedModuleNames", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "dependentModule", "ideProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "gradleModel", "Lorg/jetbrains/kotlin/gradle/KotlinGradleModel;", "addTransitiveDependenciesOnImplementedModules", "findModuleById", "moduleId", "getDependencyByFiles", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "files", "", "Ljava/io/File;", "outputToSourceSet", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ExternalSystemSourceType;", "sourceSetByName", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "getExtraProjectModelClasses", "", "Ljava/lang/Class;", "", "getToolingExtensionsClasses", "populateModuleContentRoots", "populateModuleDependencies", "useModulePerSourceSet", "", "getDependencies", "getSourceSetsMap", "kotlin.jvm.PlatformType", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    @Nullable
    private final com.intellij.openapi.util.Key<?> isAndroidProjectKey = com.intellij.openapi.util.Key.findKeyByName((String)"IS_ANDROID_PROJECT_KEY");
    private final Logger LOG;

    @Nullable
    public final com.intellij.openapi.util.Key<?> isAndroidProjectKey() {
        return this.isAndroidProjectKey;
    }

    @NotNull
    public Set<Class<? extends Object>> getToolingExtensionsClasses() {
        return SetsKt.setOf((Object[])new Class[]{KotlinGradleModelBuilder.class, Unit.class});
    }

    @NotNull
    public Set<Class<? extends Object>> getExtraProjectModelClasses() {
        return SetsKt.setOf(KotlinGradleModel.class);
    }

    private final boolean useModulePerSourceSet() {
        if (this.isAndroidProjectKey != null && Intrinsics.areEqual((Object)this.resolverCtx.getUserData(this.isAndroidProjectKey), (Object)true)) {
            return false;
        }
        ProjectResolverContext projectResolverContext = this.resolverCtx;
        Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext, (String)"resolverCtx");
        return projectResolverContext.isResolveModulePerSourceSet();
    }

    /*
     * WARNING - void declaration
     */
    private final DataNode<GradleSourceSetData> getDependencyByFiles(Collection<? extends File> files, Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> outputToSourceSet, Map<String, ? extends com.intellij.openapi.util.Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetByName) {
        void $this$mapTo$iv;
        Iterable iterable = files;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            DataNode dataNode;
            String path;
            void it;
            File file = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)it.getPath()), (String)"FileUtil.toSystemIndependentName(it.path)");
            Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> map = outputToSourceSet;
            if (map == null || (map = map.get(path)) == null || (map = (String)((com.intellij.openapi.util.Pair)map).first) == null) {
                dataNode = null;
            } else {
                Map<String, ? extends com.intellij.openapi.util.Pair<String, ExternalSystemSourceType>> targetSourceSetId = map;
                Map<String, ? extends com.intellij.openapi.util.Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> map2 = sourceSetByName;
                dataNode = map2 != null && (map2 = map2.get(targetSourceSetId)) != null ? (DataNode)((com.intellij.openapi.util.Pair)map2).first : null;
            }
            DataNode dataNode2 = dataNode;
            collection.add(dataNode2);
        }
        return (DataNode)CollectionsKt.singleOrNull((Iterable)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DataNode<? extends ModuleData>> getDependencies(DataNode<? extends ModuleData> $this$getDependencies, DataNode<ProjectData> ideProject) {
        void $this$mapNotNullTo$iv;
        Map cache;
        Map map = KotlinGradleProjectResolverExtensionKt.getDependenciesCache($this$getDependencies);
        if (map == null) {
            map = cache = (Map)new HashMap();
        }
        if (cache.containsKey(ideProject)) {
            Object v = cache.get(ideProject);
            Intrinsics.checkNotNull(v);
            return (Collection)v;
        }
        Map outputToSourceSet = (Map)ideProject.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
        Map map2 = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        if (map2 == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"ideProject.getUserData(G\u2026ETS) ?: return emptySet()");
        Map sourceSetByName = map2;
        com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)sourceSetByName.get(((ModuleData)$this$getDependencies.getData()).getId());
        if (pair == null || (pair = (ExternalSourceSet)pair.second) == null) {
            return SetsKt.emptySet();
        }
        com.intellij.openapi.util.Pair externalSourceSet = pair;
        Collection collection = externalSourceSet.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"externalSourceSet.dependencies");
        Iterable iterable = collection;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            DataNode dataNode;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            ExternalDependency dependency = (ExternalDependency)element$iv;
            boolean bl2 = false;
            ExternalDependency externalDependency = dependency;
            if (externalDependency instanceof ExternalProjectDependency) {
                if (Intrinsics.areEqual((Object)((ExternalProjectDependency)dependency).getConfigurationName(), (Object)"default")) {
                    if (ExternalSystemApiUtil.findFirstRecursively(ideProject, (BooleanFunction)new BooleanFunction<DataNode<?>>(dependency){
                        final /* synthetic */ ExternalDependency $dependency;

                        public final boolean fun(DataNode<?> it) {
                            DataNode<?> dataNode = it;
                            Intrinsics.checkNotNullExpressionValue(dataNode, (String)"it");
                            Object object = dataNode.getData();
                            if (!(object instanceof ModuleData)) {
                                object = null;
                            }
                            ModuleData moduleData = (ModuleData)object;
                            return Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)((ExternalProjectDependency)this.$dependency).getProjectPath());
                        }
                        {
                            this.$dependency = externalDependency;
                        }
                    }) == null) {
                        dataNode = null;
                    } else {
                        Object v8;
                        block14: {
                            void $this$firstOrNull$iv;
                            DataNode targetModuleNode2;
                            Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)targetModuleNode2, (Key)GradleSourceSetData.KEY);
                            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
                            Iterable iterable2 = collection2;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv2 : $this$firstOrNull$iv) {
                                DataNode it = (DataNode)element$iv2;
                                boolean bl3 = false;
                                DataNode dataNode2 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"it");
                                if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)dataNode2), (Object)"main")) continue;
                                v8 = element$iv2;
                                break block14;
                            }
                            v8 = null;
                        }
                        dataNode = v8;
                    }
                } else {
                    Collection collection3 = ((ExternalProjectDependency)dependency).getProjectDependencyArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"dependency.projectDependencyArtifacts");
                    dataNode = this.getDependencyByFiles(collection3, outputToSourceSet, sourceSetByName);
                }
            } else if (externalDependency instanceof FileCollectionDependency) {
                Collection collection4 = ((FileCollectionDependency)dependency).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"dependency.files");
                dataNode = this.getDependencyByFiles(collection4, outputToSourceSet, sourceSetByName);
            } else {
                dataNode = null;
            }
            if (dataNode == null) continue;
            DataNode dataNode3 = dataNode;
            boolean bl4 = false;
            boolean bl5 = false;
            DataNode it$iv = dataNode3;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet result2 = (LinkedHashSet)destination$iv;
        cache.put(ideProject, result2);
        KotlinGradleProjectResolverExtensionKt.setDependenciesCache($this$getDependencies, cache);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addTransitiveDependenciesOnImplementedModules(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) {
        Iterable answer$iv$iv$iv;
        Collection<DataNode<ModuleData>> $this$getOrPut$iv$iv$iv2;
        void $this$groupByTo$iv$iv;
        Collection collection;
        if (this.useModulePerSourceSet()) {
            Collection collection2 = ExternalSystemApiUtil.findAll(ideModule, (Key)GradleSourceSetData.KEY);
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
        } else {
            collection = CollectionsKt.listOf(ideModule);
        }
        Collection moduleNodesToProcess = collection;
        IdeaProject ideaProject = gradleModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)ideaProject, (String)"gradleModule.project");
        DomainObjectSet domainObjectSet = ideaProject.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)domainObjectSet, (String)"gradleModule.project.modules");
        Iterable $this$groupBy$iv = (Iterable)domainObjectSet;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            IdeaModule it = (IdeaModule)element$iv$iv;
            boolean bl = false;
            IdeaModule ideaModule = it;
            Intrinsics.checkNotNullExpressionValue((Object)ideaModule, (String)"it");
            GradleProject gradleProject = ideaModule.getGradleProject();
            Intrinsics.checkNotNullExpressionValue((Object)gradleProject, (String)"it.gradleProject");
            String key$iv$iv = gradleProject.getPath();
            $this$getOrPut$iv$iv$iv2 = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map ideaModulesByGradlePaths = destination$iv$iv;
        boolean dirtyDependencies = true;
        block1: for (DataNode currentModuleNode : moduleNodesToProcess) {
            ArrayDeque<DataNode> $i$f$groupByTo2 = new ArrayDeque<DataNode>();
            boolean bl = false;
            boolean element$iv$iv = false;
            ArrayDeque<DataNode> $this$apply22 = $i$f$groupByTo2;
            boolean bl3 = false;
            $this$apply22.add(currentModuleNode);
            ArrayDeque<DataNode> toProcess = $i$f$groupByTo2;
            Object object = new HashSet();
            element$iv$iv = false;
            boolean $this$apply22 = false;
            Object $this$apply = object;
            boolean bl4 = false;
            ((HashSet)$this$apply).add(currentModuleNode);
            Object discovered = object;
            while (true) {
                Collection<DataNode<? extends ModuleData>> collection3;
                Object object2;
                IdeaModule ideaModule;
                Object object3;
                DataNode moduleNodeForGradleModel;
                object = toProcess;
                element$iv$iv = false;
                if (!(!object.isEmpty())) continue block1;
                DataNode moduleNode = (DataNode)toProcess.pollLast();
                DataNode dataNode = moduleNodeForGradleModel = this.useModulePerSourceSet() ? ExternalSystemApiUtil.findParent((DataNode)moduleNode, (Key)ProjectKeys.MODULE) : moduleNode;
                if (Intrinsics.areEqual((Object)moduleNodeForGradleModel, ideModule) ^ true) {
                    Object object4 = moduleNodeForGradleModel;
                    if (object4 != null && (object4 = (ModuleData)object4.getData()) != null && (object4 = object4.getId()) != null) {
                        $this$apply = object4;
                        bl4 = false;
                        boolean $this$getOrPut$iv$iv$iv2 = false;
                        Object it = $this$apply;
                        boolean bl5 = false;
                        List list = (List)ideaModulesByGradlePaths.get(it);
                        object3 = list != null ? (IdeaModule)CollectionsKt.firstOrNull((List)list) : null;
                    } else {
                        object3 = null;
                    }
                } else {
                    object3 = ideaModule = gradleModule;
                }
                if ((object2 = (KotlinGradleModel)this.resolverCtx.getExtraProject(ideaModule, KotlinGradleModel.class)) == null || (object2 = object2.getImplements()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object implementsModuleIds = object2;
                $this$getOrPut$iv$iv$iv2 = implementsModuleIds.iterator();
                while ($this$getOrPut$iv$iv$iv2.hasNext()) {
                    DataNode<ModuleData> targetModule;
                    String implementsModuleId = (String)$this$getOrPut$iv$iv$iv2.next();
                    if (this.findModuleById(ideProject, gradleModule, implementsModuleId) == null) {
                        continue;
                    }
                    if (this.useModulePerSourceSet()) {
                        void $this$associateByTo$iv$iv;
                        void $this$associateBy$iv;
                        Collection collection4 = ExternalSystemApiUtil.findAll(targetModule, (Key)GradleSourceSetData.KEY);
                        Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"ExternalSystemApiUtil\n  \u2026 GradleSourceSetData.KEY)");
                        answer$iv$iv$iv = collection4;
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        void var22_49 = $this$associateBy$iv;
                        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                            void it;
                            DataNode dataNode2 = (DataNode)element$iv$iv2;
                            Map map = destination$iv$iv2;
                            boolean bl6 = false;
                            void v13 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
                            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v13);
                            map.put(string, element$iv$iv2);
                        }
                        Map targetSourceSetsByName = destination$iv$iv2;
                        DataNode<ModuleData> dataNode3 = (DataNode<ModuleData>)targetSourceSetsByName.get("main");
                        if (dataNode3 == null) {
                            dataNode3 = targetModule;
                        }
                        DataNode<ModuleData> targetMainSourceSet = dataNode3;
                        DataNode dataNode4 = currentModuleNode;
                        Intrinsics.checkNotNullExpressionValue((Object)dataNode4, (String)"currentModuleNode");
                        DataNode targetSourceSet = (DataNode)targetSourceSetsByName.get(this.getSourceSetName((DataNode<? extends ModuleData>)dataNode4));
                        if (targetSourceSet != null) {
                            this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, (DataNode<? extends ModuleData>)targetSourceSet);
                        }
                        if (!Intrinsics.areEqual((Object)this.getSourceSetName((DataNode<? extends ModuleData>)currentModuleNode), (Object)"test") || !(Intrinsics.areEqual(targetMainSourceSet, (Object)targetSourceSet) ^ true)) continue;
                        this.addDependency((DataNode<? extends ModuleData>)currentModuleNode, targetMainSourceSet);
                        continue;
                    }
                    dirtyDependencies = true;
                    DataNode dataNode5 = currentModuleNode;
                    Intrinsics.checkNotNullExpressionValue((Object)dataNode5, (String)"currentModuleNode");
                    this.addDependency((DataNode<? extends ModuleData>)dataNode5, targetModule);
                }
                if (this.useModulePerSourceSet()) {
                    DataNode dataNode6 = moduleNode;
                    Intrinsics.checkNotNullExpressionValue((Object)dataNode6, (String)"moduleNode");
                    collection3 = this.getDependencies((DataNode<? extends ModuleData>)dataNode6, ideProject);
                } else if (dirtyDependencies) {
                    IdeaProject ideaProject2 = gradleModule.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)ideaProject2, (String)"gradleModule.project");
                    $this$getOrPut$iv$iv$iv2 = KotlinGradleModelFacadeKt.getDependencyModules(ideModule, ideaProject2);
                    boolean targetModule = false;
                    boolean bl7 = false;
                    Collection<DataNode<ModuleData>> it = $this$getOrPut$iv$iv$iv2;
                    boolean bl8 = false;
                    dirtyDependencies = false;
                    collection3 = $this$getOrPut$iv$iv$iv2;
                } else {
                    collection3 = CollectionsKt.emptyList();
                }
                Collection<DataNode<? extends ModuleData>> dependencies = collection3;
                Iterable $this$filterTo$iv = dependencies;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    DataNode p1 = (DataNode)element$iv;
                    boolean bl9 = false;
                    if (!((HashSet)discovered).add(p1)) continue;
                    ((Collection)toProcess).add(element$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        block11: {
            Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
            Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
            Intrinsics.checkNotNullParameter(ideProject, (String)"ideProject");
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Start populate module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
            }
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext, (String)"resolverCtx");
            KotlinMPPGradleModel mppModel = KotlinMPPGradleProjectResolverKt.getMppModel(projectResolverContext, gradleModule);
            if (mppModel == null) break block11;
            Iterable $this$forEach$iv = mppModel.getTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                StringBuilder stringBuilder;
                FUSEventGroups fUSEventGroups;
                KotlinFUSLogger.Companion companion;
                block13: {
                    block12: {
                        void it;
                        KotlinTarget target = (KotlinTarget)element$iv;
                        boolean bl = false;
                        companion = KotlinFUSLogger.Companion;
                        fUSEventGroups = FUSEventGroups.GradleTarget;
                        stringBuilder = new StringBuilder().append("MPP.").append(target.getPlatform().getId());
                        string = target.getPresetName();
                        if (string == null) break block12;
                        String string2 = string;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String string3 = string2;
                        StringBuilder stringBuilder2 = stringBuilder;
                        FUSEventGroups fUSEventGroups2 = fUSEventGroups;
                        KotlinFUSLogger.Companion companion2 = companion;
                        boolean bl4 = false;
                        String string4 = '.' + (String)it;
                        companion = companion2;
                        fUSEventGroups = fUSEventGroups2;
                        stringBuilder = stringBuilder2;
                        string = string4;
                        if (string != null) break block13;
                    }
                    string = "";
                }
                companion.log(fUSEventGroups, stringBuilder.append(string).toString());
            }
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel == null) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinGradleModel, (String)"resolverCtx.getExtraProj\u2026e, ideModule, ideProject)");
        KotlinGradleModel gradleModel = kotlinGradleModel;
        if (!this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        this.addTransitiveDependenciesOnImplementedModules(gradleModule, ideModule, ideProject);
        KotlinGradleProjectResolverExtensionKt.setResolved(ideModule, true);
        KotlinGradleProjectResolverExtensionKt.setHasKotlinPlugin(ideModule, gradleModel.getHasKotlinPlugin());
        KotlinGradleProjectResolverExtensionKt.setCompilerArgumentsBySourceSet(ideModule, KotlinGradleModelBuilderKt.deepCopy((Map)gradleModel.getCompilerArgumentsBySourceSet()));
        KotlinGradleProjectResolverExtensionKt.setCoroutines(ideModule, gradleModel.getCoroutines());
        KotlinGradleProjectResolverExtensionKt.setPlatformPluginId(ideModule, gradleModel.getPlatformPluginId());
        if (gradleModel.getHasKotlinPlugin()) {
            String string = gradleModel.getKotlinTarget();
            if (string == null) {
                string = "unknown";
            }
            KotlinFUSLogger.Companion.log(FUSEventGroups.GradleTarget, string);
        }
        this.addImplementedModuleNames(gradleModule, ideModule, ideProject, gradleModel);
        if (this.useModulePerSourceSet()) {
            super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Finish populating module dependencies. Gradle module: [" + gradleModule + "], Ide module: [" + ideModule + "], Ide project: [" + ideProject + ']');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addImplementedModuleNames(IdeaModule gradleModule, DataNode<ModuleData> dependentModule, DataNode<ProjectData> ideProject, KotlinGradleModel gradleModel) {
        Object $this$map$iv;
        Object dependentSourceSets;
        Iterator iterator;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = gradleModel.getImplements();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.findModuleById(ideProject, gradleModule, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            DataNode<ModuleData> it$iv$iv = iterator;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List implementedModules = (List)destination$iv$iv;
        if (this.useModulePerSourceSet()) {
            Object object;
            Collection collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            dependentSourceSets = this.getSourceSetsMap(dependentModule);
            $this$map$iv = implementedModules;
            boolean $i$f$map22 = false;
            Iterable $i$f$mapNotNullTo2 = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                item$iv$iv = iterator2.next();
                element$iv$iv = (DataNode)item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl = false;
                object = this.getSourceSetsMap((DataNode<ModuleData>)it);
                collection.add(object);
            }
            List implementedSourceSetMaps = (List)destination$iv$iv22;
            $this$mapTo$iv$iv = dependentSourceSets;
            boolean destination$iv$iv22 = false;
            Iterator $i$f$map22 = $this$mapTo$iv$iv.entrySet().iterator();
            while ($i$f$map22.hasNext()) {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Object $i$f$mapTo2 = $this$map$iv = $i$f$map22.next();
                boolean bl = false;
                $this$mapTo$iv$iv = (String)$i$f$mapTo2.getKey();
                $i$f$mapTo2 = $this$map$iv;
                bl = false;
                DataNode dependentSourceSet = (DataNode)$i$f$mapTo2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)dependentSourceSet, (String)"dependentSourceSet");
                $i$f$mapTo2 = implementedSourceSetMaps;
                boolean $i$f$mapNotNull2 = false;
                item$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo3 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                iterator = $this$forEach$iv$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    void sourceSetName;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl6 = false;
                    Map it = (Map)element$iv$iv2;
                    boolean bl7 = false;
                    DataNode dataNode = (DataNode)it.get(sourceSetName);
                    if ((dataNode != null && (dataNode = (GradleSourceSetData)dataNode.getData()) != null ? dataNode.getInternalName() : null) == null) continue;
                    string = string;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    String it$iv$iv = string;
                    boolean bl10 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                object = (List)destination$iv$iv3;
                KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames((DataNode<? extends ModuleData>)collection, (List<String>)object);
            }
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv2;
            dependentSourceSets = implementedModules;
            DataNode<ModuleData> dataNode = dependentModule;
            boolean $i$f$map = false;
            $this$map$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataNode $i$f$mapNotNull2 = (DataNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.data");
                String string = ((ModuleData)object).getInternalName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            KotlinGradleProjectResolverExtensionKt.setImplementedModuleNames(dataNode, (List<String>)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DataNode<GradleSourceSetData>> getSourceSetsMap(DataNode<ModuleData> $this$getSourceSetsMap) {
        void $this$associateByTo$iv$iv;
        Collection collection = ExternalSystemApiUtil.getChildren($this$getSourceSetsMap, (Key)GradleSourceSetData.KEY);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026 GradleSourceSetData.KEY)");
        Iterable $this$associateBy$iv = collection;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string = this.getSourceSetName((DataNode<? extends ModuleData>)v1);
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final String getSourceSetName(DataNode<? extends ModuleData> $this$sourceSetName) {
        Object object;
        Object object2 = $this$sourceSetName.getData();
        if (!(object2 instanceof GradleSourceSetData)) {
            object2 = null;
        }
        return (object = (GradleSourceSetData)object2) != null && (object = object.getId()) != null ? StringsKt.substringAfterLast$default((String)object, (char)':', null, (int)2, null) : null;
    }

    private final void addDependency(DataNode<? extends ModuleData> ideModule, DataNode<? extends ModuleData> targetModule) {
        ModuleDependencyData moduleDependencyData = new ModuleDependencyData((ModuleData)ideModule.getData(), (ModuleData)targetModule.getData());
        moduleDependencyData.setScope(DependencyScope.COMPILE);
        moduleDependencyData.setExported(false);
        moduleDependencyData.setProductionOnTestDependency(Intrinsics.areEqual((Object)this.getSourceSetName(targetModule), (Object)"test"));
        ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
    }

    private final DataNode<ModuleData> findModuleById(DataNode<ProjectData> ideProject, IdeaModule gradleModule, String moduleId) {
        Object v8;
        block4: {
            String string;
            ProjectResolverContext projectResolverContext = this.resolverCtx;
            Intrinsics.checkNotNullExpressionValue((Object)projectResolverContext, (String)"resolverCtx");
            ProjectImportAction.AllModels allModels = projectResolverContext.getModels();
            Intrinsics.checkNotNullExpressionValue((Object)allModels, (String)"resolverCtx.models");
            boolean isCompositeProject = Intrinsics.areEqual((Object)allModels.getIdeaProject(), (Object)gradleModule.getProject()) ^ true;
            if (isCompositeProject && StringsKt.startsWith$default((String)moduleId, (String)":", (boolean)false, (int)2, null)) {
                IdeaProject ideaProject = gradleModule.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)ideaProject, (String)"gradleModule.project");
                string = ideaProject.getName();
            } else {
                string = "";
            }
            String compositePrefix = string;
            String fullModuleId = compositePrefix + moduleId;
            Collection collection = ideProject.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ideProject.children");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DataNode it = (DataNode)t;
                boolean bl3 = false;
                DataNode dataNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
                Object object = dataNode.getData();
                if (!(object instanceof ModuleData)) {
                    object = null;
                }
                ModuleData moduleData = (ModuleData)object;
                if (!Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)fullModuleId)) continue;
                v8 = t;
                break block4;
            }
            v8 = null;
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     */
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
        String string = GradleProjectResolverUtil.getModuleId((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GradleProjectResolverUti\u2026esolverCtx, gradleModule)");
        String moduleNamePrefix = string;
        KotlinGradleModel kotlinGradleModel = (KotlinGradleModel)this.resolverCtx.getExtraProject(gradleModule, KotlinGradleModel.class);
        if (kotlinGradleModel != null) {
            void $this$filterTo$iv$iv;
            List list;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            KotlinGradleModel kotlinGradleModel2 = kotlinGradleModel;
            boolean bl = false;
            boolean bl2 = false;
            KotlinGradleModel gradleModel = kotlinGradleModel2;
            boolean bl3 = false;
            KotlinGradleFUSLogger.Companion.populateGradleUserDir(gradleModel.getGradleUserHome());
            Object $this$flatMap$iv = gradleModel.getKotlinTaskProperties();
            boolean $i$f$flatMap = false;
            Map map = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var14_18 = $this$flatMapTo$iv$iv;
            boolean bl4 = false;
            Object object = var14_18.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = object.next();
                boolean bl5 = false;
                List list2 = ((KotlinTaskProperties)it.getValue()).getPureKotlinSourceFolders();
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                String string2 = it.getAbsolutePath();
                collection.add(string2);
            }
            List gradleModelPureKotlinSourceFolders = (List)destination$iv$iv;
            if (KotlinGradleProjectResolverExtensionKt.getPureKotlinSourceFolders(ideModule).isEmpty()) {
                list = gradleModelPureKotlinSourceFolders;
            } else {
                Collection collection = gradleModelPureKotlinSourceFolders;
                List<String> list3 = KotlinGradleProjectResolverExtensionKt.getPureKotlinSourceFolders(ideModule);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"ideModule.pureKotlinSourceFolders");
                list = CollectionsKt.plus((Collection)collection, (Iterable)list3);
            }
            KotlinGradleProjectResolverExtensionKt.setPureKotlinSourceFolders(ideModule, list);
            Collection collection = ideModule.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ideModule.children");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl7 = false;
                DataNode dataNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
                if (!(dataNode.getData() instanceof GradleSourceSetData)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Collection gradleSourceSets = (List)destination$iv$iv2;
            for (DataNode gradleSourceSetNode : gradleSourceSets) {
                void $this$filterTo$iv$iv2;
                Map $this$filter$iv2 = gradleModel.getKotlinTaskProperties();
                boolean $i$f$filter2 = false;
                Map item$iv$iv = $this$filter$iv2;
                Map destination$iv$iv3 = new LinkedHashMap();
                boolean $i$f$filterTo2 = false;
                void bl7 = $this$filterTo$iv$iv2;
                boolean bl5 = false;
                Iterator iterator = bl7.entrySet().iterator();
                while (iterator.hasNext()) {
                    void k;
                    Map.Entry element$iv$iv;
                    Map.Entry $dstr$k$v = element$iv$iv = iterator.next();
                    boolean bl8 = false;
                    Map.Entry entry = $dstr$k$v;
                    boolean bl9 = false;
                    String string3 = (String)entry.getKey();
                    entry = $dstr$k$v;
                    bl9 = false;
                    KotlinTaskProperties v = (KotlinTaskProperties)entry.getValue();
                    Object object2 = gradleSourceSetNode.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradleSourceSetNode.data");
                    if (!Intrinsics.areEqual((Object)((GradleSourceSetData)object2).getId(), (Object)(moduleNamePrefix + ':' + (String)k))) continue;
                    destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Pair propertiesForSourceSet = (Pair)CollectionsKt.singleOrNull((List)MapsKt.toList((Map)destination$iv$iv3));
                Collection collection2 = gradleSourceSetNode.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"gradleSourceSetNode.children");
                Iterable $this$forEach$iv = collection2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    Iterable it;
                    void $this$filterTo$iv$iv3;
                    Pair pair;
                    String packagePrefix;
                    ContentRootData data;
                    DataNode dataNode = (DataNode)element$iv;
                    boolean bl10 = false;
                    DataNode dataNode2 = dataNode;
                    Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"dataNode");
                    Object object3 = dataNode2.getData();
                    if (!(object3 instanceof ContentRootData)) {
                        object3 = null;
                    }
                    if ((data = (ContentRootData)object3) == null || (packagePrefix = (pair = propertiesForSourceSet) != null && (pair = (KotlinTaskProperties)pair.getSecond()) != null ? pair.getPackagePrefix() : null) == null) continue;
                    Object $this$filter$iv3 = ExternalSystemSourceType.values();
                    boolean $i$f$filter3 = false;
                    ExternalSystemSourceType[] bl8 = $this$filter$iv3;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv3) {
                        it = element$iv$iv;
                        boolean bl11 = false;
                        if (!(!it.isResource() && !it.isGenerated())) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    $this$filter$iv3 = (List)destination$iv$iv4;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$mapTo$iv$iv2;
                        Collection paths;
                        ExternalSystemSourceType type = (ExternalSystemSourceType)element$iv2;
                        boolean bl12 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)data.getPaths(type), (String)"data.getPaths(type)");
                        Iterable $this$map$iv2 = paths;
                        boolean $i$f$map2 = false;
                        it = $this$map$iv2;
                        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                            void it2;
                            ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)item$iv$iv2;
                            Collection collection3 = destination$iv$iv5;
                            boolean bl13 = false;
                            void v13 = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
                            ContentRootData.SourceRoot sourceRoot2 = new ContentRootData.SourceRoot(v13.getPath(), packagePrefix);
                            collection3.add(sourceRoot2);
                        }
                        List newPaths = (List)destination$iv$iv5;
                        paths.clear();
                        paths.addAll(newPaths);
                    }
                }
            }
        }
    }

    public KotlinGradleProjectResolverExtension() {
        Logger logger = Logger.getInstance(PsiPrecedences.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(PsiPrecedences::class.java)");
        this.LOG = logger;
    }
}

