/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "addSupport", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "specifyPluginVersionIfNeeded", "", "explicitPluginVersion", "getDependencies", "", "getDescription", "getPluginExpression", "getPluginId", "kotlin.gradle.gradle-idea"})
public class GradleKotlinJavaFrameworkSupportProvider
extends GradleKotlinFrameworkSupportProvider {
    @Override
    @NotNull
    protected String getPluginId() {
        return "kotlin";
    }

    @Override
    @NotNull
    protected String getPluginExpression() {
        return "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @NotNull
    protected List<String> getDependencies(@Nullable Sdk sdk) {
        return CollectionsKt.listOf((Object)KotlinRuntimeLibraryUtilKt.getStdlibArtifactId((Sdk)sdk, (String)KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion()));
    }

    @Override
    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module, @Nullable Sdk sdk, boolean specifyPluginVersionIfNeeded, @Nullable String explicitPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.addSupport(buildScriptData, module, sdk, specifyPluginVersionIfNeeded, explicitPluginVersion);
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget((Sdk)sdk, (String)KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion());
        if (jvmTarget != null) {
            String description = jvmTarget.getDescription();
            buildScriptData.addOther("compileKotlin {\n    kotlinOptions.jvmTarget = \"" + description + "\"\n}\n\n");
            buildScriptData.addOther("compileTestKotlin {\n    kotlinOptions.jvmTarget = \"" + description + "\"\n}\n");
        }
    }

    @Override
    @NotNull
    protected String getDescription() {
        return KotlinIdeaGradleBundle.message("description.text.a.single.platform.kotlin.library.or.application.targeting.the.jvm", new Object[0]);
    }

    public GradleKotlinJavaFrameworkSupportProvider(@NotNull String frameworkTypeId, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Icon icon = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"KotlinIcons.SMALL_LOGO");
        super(frameworkTypeId, displayName, icon);
    }

    public /* synthetic */ GradleKotlinJavaFrameworkSupportProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "KOTLIN";
        }
        if ((n & 2) != 0) {
            string2 = "Kotlin/JVM";
        }
        this(string, string2);
    }

    public GradleKotlinJavaFrameworkSupportProvider() {
        this(null, null, 3, null);
    }
}

