/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.IconChunk;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.TextChunk;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WorkBenchLoadingPanel
extends JPanel {
    private final JBLoadingPanel myLoadingPanel;
    private EmptyStatePanel myMessagePanel = null;

    public WorkBenchLoadingPanel(LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        super(new BorderLayout());
        this.myLoadingPanel = new JBLoadingPanel(manager, parent, startDelayMs);
        super.add((Component)this.myLoadingPanel);
    }

    public void startLoading() {
        this.resumeLoading();
        this.myLoadingPanel.startLoading();
    }

    public void stopLoading() {
        this.resumeLoading();
        this.myLoadingPanel.stopLoading();
    }

    public void setLoadingText(String text) {
        this.myLoadingPanel.setLoadingText(text);
    }

    @VisibleForTesting
    public boolean isLoading() {
        return this.myLoadingPanel.isLoading();
    }

    @VisibleForTesting
    public boolean hasError() {
        return this.myMessagePanel != null;
    }

    boolean isLoadingOrHasError() {
        return this.isLoading() || this.hasError();
    }

    @Override
    public Component add(Component comp) {
        return this.myLoadingPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myLoadingPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myLoadingPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myLoadingPanel.getPreferredSize();
    }

    public void abortLoading(String message, Icon icon) {
        if (this.myMessagePanel != null) {
            super.remove(this.myMessagePanel);
        }
        this.myMessagePanel = new EmptyStatePanel(new LabelData(new IconChunk(icon), new TextChunk(message)));
        super.remove((Component)this.myLoadingPanel);
        super.add(this.myMessagePanel);
    }

    private void resumeLoading() {
        if (this.myMessagePanel != null) {
            super.remove(this.myMessagePanel);
            super.add((Component)this.myLoadingPanel);
            this.myMessagePanel = null;
        }
    }
}

