/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.CommonTabbedPaneUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public class CommonTabbedPane
extends JTabbedPane {
    @NotNull
    private final CommonTabbedPaneUI myUi;

    public CommonTabbedPane() {
        this(new CommonTabbedPaneUI());
    }

    public CommonTabbedPane(@NotNull CommonTabbedPaneUI ui) {
        this.myUi = ui;
        this.setUI(this.myUi);
        this.getActionMap().put("navigatePrevious", new NavigateAction(ActionDirection.LEFT));
        this.getActionMap().put("navigateNext", new NavigateAction(ActionDirection.RIGHT));
        this.getActionMap().put("navigateLeft", new NavigateAction(ActionDirection.LEFT));
        this.getActionMap().put("navigateRight", new NavigateAction(ActionDirection.RIGHT));
    }

    @Override
    public void updateUI() {
        this.setUI(this.myUi);
    }

    final class NavigateAction
    extends AbstractAction {
        private final ActionDirection myDirection;

        NavigateAction(ActionDirection direction) {
            this.myDirection = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tabCount = CommonTabbedPane.this.getTabCount();
            if (this.myDirection == ActionDirection.RIGHT) {
                CommonTabbedPane.this.setSelectedIndex((CommonTabbedPane.this.getSelectedIndex() + 1) % tabCount);
            } else {
                CommonTabbedPane.this.setSelectedIndex((CommonTabbedPane.this.getSelectedIndex() - 1 + tabCount) % tabCount);
            }
        }
    }

    static enum ActionDirection {
        LEFT,
        RIGHT;

    }
}

