/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.updater;

import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.updater.Updatable;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Updater
implements StopwatchTimer.TickHandler {
    public static final float DEFAULT_LERP_FRACTION = 0.99f;
    public static final float DEFAULT_LERP_THRESHOLD_PERCENTAGE = 0.001f;
    private final List<Updatable> mComponents = new LinkedList<Updatable>();
    private List<Updatable> mToRegister = new LinkedList<Updatable>();
    private List<Updatable> mToUnregister = new LinkedList<Updatable>();
    private final StopwatchTimer mTimer;
    private boolean mReset;
    private boolean mUpdating = false;

    public Updater(@NotNull StopwatchTimer timer) {
        this.mTimer = timer;
        this.mTimer.setHandler(this);
        this.mTimer.start();
    }

    public StopwatchTimer getTimer() {
        return this.mTimer;
    }

    public void register(Updatable updatable) {
        if (this.mUpdating) {
            this.mToRegister.add(updatable);
        } else {
            this.mComponents.add(updatable);
        }
    }

    public void register(@NotNull List<Updatable> updatables) {
        for (Updatable updatable : updatables) {
            this.register(updatable);
        }
    }

    public void unregister(@NotNull Updatable updatable) {
        if (this.mUpdating) {
            this.mToUnregister.add(updatable);
        } else {
            this.mComponents.remove(updatable);
        }
    }

    public void stop() {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
        }
    }

    public boolean isRunning() {
        return this.mTimer.isRunning();
    }

    public void reset() {
        this.mReset = true;
    }

    @Override
    public void onTick(long elapsedNs) {
        this.mUpdating = true;
        if (this.mReset) {
            this.mComponents.forEach(Updatable::reset);
            this.mReset = false;
        }
        this.mComponents.forEach(component -> component.update(elapsedNs));
        this.mComponents.forEach(Updatable::postUpdate);
        this.mUpdating = false;
        this.mToUnregister.forEach(this::unregister);
        this.mToRegister.forEach(this::register);
        this.mToUnregister.clear();
        this.mToRegister.clear();
    }

    public static float lerp(float from, float to, float fraction, long frameLengthNs, float threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        double length = (double)frameLengthNs / 1.0E9;
        float q = (float)Math.pow(1.0f - fraction, length);
        return from * q + to * (1.0f - q);
    }

    public static double lerp(double from, double to, float fraction, long frameLengthNs, double threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        double length = (double)frameLengthNs / 1.0E9;
        double q = Math.pow(1.0f - fraction, length);
        return from * q + to * (1.0 - q);
    }

    public static double lerp(double a, double b, float factor) {
        return a + (b - a) * (double)factor;
    }
}

