/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.trackgroup;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DragAndDropModelListElement;
import com.android.tools.adtui.model.TooltipModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackModel<M, R extends Enum>
implements DragAndDropModelListElement {
    private final M myDataModel;
    private final R myRendererType;
    @NotNull
    private final String myTitle;
    @Nullable
    private final String myTitleTooltip;
    private final boolean myHideHeader;
    private final int myId;
    private final boolean myIsCollapsible;
    private boolean myIsCollapsed;
    @NotNull
    private final AspectModel<Aspect> myAspectModel = new AspectModel();
    @Nullable
    private TooltipModel myActiveTooltipModel;

    private TrackModel(@NotNull Builder<M, R> builder) {
        this.myDataModel = ((Builder)builder).myDataModel;
        this.myRendererType = ((Builder)builder).myRendererType;
        this.myTitle = ((Builder)builder).myTitle;
        this.myTitleTooltip = ((Builder)builder).myTitleTooltip;
        this.myHideHeader = ((Builder)builder).myHideHeader;
        this.myIsCollapsible = ((Builder)builder).myIsCollapsible;
        this.myIsCollapsed = ((Builder)builder).myIsCollapsed;
        this.myId = ((Builder)builder).myId;
        this.myActiveTooltipModel = ((Builder)builder).myDefaultTooltipModel;
    }

    @NotNull
    public M getDataModel() {
        return this.myDataModel;
    }

    @NotNull
    public R getRendererType() {
        return this.myRendererType;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitleTooltip() {
        return this.myTitleTooltip;
    }

    public boolean getHideHeader() {
        return this.myHideHeader;
    }

    @Override
    public int getId() {
        return this.myId;
    }

    @Nullable
    public TooltipModel getActiveTooltipModel() {
        return this.myActiveTooltipModel;
    }

    public void setActiveTooltipModel(@Nullable TooltipModel tooltipModel) {
        this.myActiveTooltipModel = tooltipModel;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.myIsCollapsible && this.myIsCollapsed != collapsed) {
            this.myIsCollapsed = collapsed;
            this.myAspectModel.changed(Aspect.COLLAPSE_CHANGE);
        }
    }

    public boolean isCollapsed() {
        return this.myIsCollapsed;
    }

    public boolean isCollapsible() {
        return this.myIsCollapsible;
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        return this.myAspectModel;
    }

    public static <M, R extends Enum> Builder<M, R> newBuilder(@NotNull M dataModel, @NotNull R rendererType, @NotNull String title) {
        return new Builder(dataModel, rendererType, title, null);
    }

    public static class Builder<M, R extends Enum> {
        private final M myDataModel;
        private final R myRendererType;
        private final String myTitle;
        private boolean myHideHeader;
        private boolean myIsCollapsed;
        private boolean myIsCollapsible;
        private int myId;
        private TooltipModel myDefaultTooltipModel;
        private String myTitleTooltip;

        private Builder(@NotNull M dataModel, @NotNull R rendererType, @NotNull String title) {
            this.myDataModel = dataModel;
            this.myRendererType = rendererType;
            this.myTitle = title;
            this.myHideHeader = false;
            this.myIsCollapsed = false;
            this.myIsCollapsible = false;
            this.myId = -1;
            this.myDefaultTooltipModel = null;
            this.myTitleTooltip = null;
        }

        @NotNull
        public Builder<M, R> setTitleTooltip(@Nullable String titleTooltip) {
            this.myTitleTooltip = titleTooltip;
            return this;
        }

        @NotNull
        public Builder<M, R> setHideHeader(boolean hideHeader) {
            this.myHideHeader = hideHeader;
            return this;
        }

        @NotNull
        public Builder<M, R> setCollapsed(boolean collapsed) {
            this.myIsCollapsed = collapsed;
            return this;
        }

        @NotNull
        public Builder<M, R> setCollapsible(boolean collapsible) {
            this.myIsCollapsible = collapsible;
            return this;
        }

        @NotNull
        protected Builder<M, R> setId(int id) {
            this.myId = id;
            return this;
        }

        @NotNull
        public Builder<M, R> setDefaultTooltipModel(TooltipModel defaultTooltipModel) {
            this.myDefaultTooltipModel = defaultTooltipModel;
            return this;
        }

        @NotNull
        public TrackModel<M, R> build() {
            return new TrackModel(this);
        }

        /* synthetic */ Builder(Object x0, Enum x1, String x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static enum Aspect {
        COLLAPSE_CHANGE;

    }
}

