/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.trackgroup;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.BoxSelectionModel;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.trackgroup.TrackGroupActionListener;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackGroupModel
extends DragAndDropListModel<TrackModel> {
    private static final AtomicInteger TRACK_ID_GENERATOR = new AtomicInteger();
    private final String myTitle;
    @Nullable
    private final String myTitleHelpText;
    @Nullable
    private final String myTitleHelpLinkText;
    @Nullable
    private final String myTitleHelpLinkUrl;
    private final boolean myCollapsedInitially;
    private final boolean myHideHeader;
    private final boolean myTrackSelectable;
    @Nullable
    private final BoxSelectionModel myBoxSelectionModel;
    private final AspectObserver myObserver = new AspectObserver();
    private final List<TrackGroupActionListener> myActionListeners = new ArrayList<TrackGroupActionListener>();

    private TrackGroupModel(Builder builder) {
        this.myTitle = builder.myTitle;
        this.myTitleHelpText = builder.myTitleHelpText;
        this.myTitleHelpLinkText = builder.myTitleHelpLinkText;
        this.myTitleHelpLinkUrl = builder.myTitleHelpLinkUrl;
        this.myCollapsedInitially = builder.myCollapsedInitially;
        this.myHideHeader = builder.myHideHeader;
        this.myTrackSelectable = builder.myTrackSelectable;
        this.myBoxSelectionModel = builder.myBoxSelectionModel;
    }

    public <M, R extends Enum> void addTrackModel(@NotNull TrackModel.Builder<M, R> builder) {
        TrackModel trackModel = builder.setId(TRACK_ID_GENERATOR.getAndIncrement()).build();
        this.insertOrderedElement(trackModel);
        trackModel.getAspectModel().addDependency(this.myObserver).onChange(TrackModel.Aspect.COLLAPSE_CHANGE, () -> {
            int index = this.indexOf(trackModel);
            if (index != -1) {
                this.fireContentsChanged(this, index, index);
            }
        });
    }

    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitleHelpText() {
        return this.myTitleHelpText;
    }

    @Nullable
    public String getTitleHelpLinkText() {
        return this.myTitleHelpLinkText;
    }

    @Nullable
    public String getTitleHelpLinkUrl() {
        return this.myTitleHelpLinkUrl;
    }

    public boolean isCollapsedInitially() {
        return this.myCollapsedInitially;
    }

    public boolean getHideHeader() {
        return this.myHideHeader;
    }

    public boolean isTrackSelectable() {
        return this.myTrackSelectable;
    }

    @Nullable
    public BoxSelectionModel getBoxSelectionModel() {
        return this.myBoxSelectionModel;
    }

    public void addActionListener(@NotNull TrackGroupActionListener actionListener) {
        this.myActionListeners.add(actionListener);
    }

    @NotNull
    public List<TrackGroupActionListener> getActionListeners() {
        return this.myActionListeners;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String myTitle = "";
        @Nullable
        private String myTitleHelpText = null;
        @Nullable
        private String myTitleHelpLinkText = null;
        @Nullable
        private String myTitleHelpLinkUrl = null;
        private boolean myCollapsedInitially = false;
        private boolean myHideHeader = false;
        private boolean myTrackSelectable = false;
        @Nullable
        private BoxSelectionModel myBoxSelectionModel;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.myTitle = title;
            return this;
        }

        public Builder setTitleHelpText(@NotNull String titleHelpText) {
            this.myTitleHelpText = titleHelpText;
            return this;
        }

        public Builder setTitleHelpLink(@NotNull String titleHelpLinkText, @NotNull String titleHelpLinkUrl) {
            this.myTitleHelpLinkText = titleHelpLinkText;
            this.myTitleHelpLinkUrl = titleHelpLinkUrl;
            return this;
        }

        public Builder setCollapsedInitially(boolean collapsedInitially) {
            this.myCollapsedInitially = collapsedInitially;
            return this;
        }

        public Builder setHideHeader(boolean hideHeader) {
            this.myHideHeader = hideHeader;
            return this;
        }

        public Builder setTrackSelectable(boolean trackSelectable) {
            this.myTrackSelectable = trackSelectable;
            return this;
        }

        public Builder setBoxSelectionModel(BoxSelectionModel rangeSelectionModel) {
            this.myBoxSelectionModel = rangeSelectionModel;
            return this;
        }

        public TrackGroupModel build() {
            return new TrackGroupModel(this);
        }
    }
}

