/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class StreamingTimeline
extends AspectModel<Aspect>
implements Updatable,
Timeline {
    public static final double DEFAULT_ZOOM_PERCENT = 0.25;
    public static final double ZOOM_MIDDLE_FOCAL_POINT = 0.5;
    public static final float ZOOM_LERP_THRESHOLD_NS = 10.0f;
    public static final double ZOOM_IN_DELTA_RANGE_US_MAX_RATIO = 0.9;
    @VisibleForTesting
    public static final long DEFAULT_VIEW_LENGTH_US = TimeUnit.SECONDS.toMicros(30L);
    @NotNull
    private final Updater myUpdater;
    @NotNull
    private final Range myDataRangeUs = new Range(0.0, 0.0);
    @NotNull
    private final Range myViewRangeUs = new Range(0.0, 0.0);
    @NotNull
    private final Range mySelectionRangeUs;
    @NotNull
    private final Range myTooltipRangeUs;
    private boolean myStreaming;
    private float myStreamingFactor;
    private Range myZoomLeft = new Range(0.0, 0.0);
    private boolean myCanStream = true;
    private long myDataStartTimeNs;
    private long myDataLengthNs;
    private boolean myIsReset = false;
    private long myResetTimeNs;
    private boolean myIsPaused = false;
    private long myPausedTime;
    private double myTargetRangeMaxUs = -1.0;
    private float myJumpFactor;

    public StreamingTimeline(@NotNull Updater updater) {
        this.mySelectionRangeUs = new Range();
        this.myTooltipRangeUs = new Range();
        this.myUpdater = updater;
        this.myUpdater.register(this);
    }

    public void setStreaming(boolean isStreaming) {
        if (!this.myCanStream && isStreaming) {
            isStreaming = false;
        }
        if (this.myStreaming == isStreaming) {
            return;
        }
        assert (this.myCanStream || !isStreaming);
        this.myStreaming = isStreaming;
        this.update(0L);
        this.changed(Aspect.STREAMING);
    }

    public boolean isStreaming() {
        return this.myStreaming && !this.myIsPaused;
    }

    public void setCanStream(boolean canStream) {
        this.myCanStream = canStream;
        if (!this.myCanStream && this.myStreaming) {
            this.setStreaming(false);
        }
    }

    public boolean canStream() {
        return this.myCanStream && !this.myIsPaused;
    }

    public void toggleStreaming() {
        this.myZoomLeft.set(0.0, 0.0);
        this.setStreaming(!this.isStreaming());
    }

    public boolean isPaused() {
        return this.myIsPaused;
    }

    public void setIsPaused(boolean paused) {
        this.myIsPaused = paused;
        if (this.myIsPaused) {
            this.myPausedTime = this.myDataLengthNs;
        }
    }

    @Override
    @NotNull
    public Range getDataRange() {
        return this.myDataRangeUs;
    }

    @Override
    @NotNull
    public Range getViewRange() {
        return this.myViewRangeUs;
    }

    @Override
    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRangeUs;
    }

    @Override
    @NotNull
    public Range getTooltipRange() {
        return this.myTooltipRangeUs;
    }

    @Override
    public void update(long elapsedNs) {
        if (this.myIsReset) {
            elapsedNs = this.myUpdater.getTimer().getCurrentTimeNs() - this.myResetTimeNs;
            this.myResetTimeNs = 0L;
            this.myIsReset = false;
        }
        this.myDataLengthNs += elapsedNs;
        long maxTimelineTimeNs = this.myDataLengthNs;
        if (this.myIsPaused) {
            maxTimelineTimeNs = this.myPausedTime;
        }
        long deviceNowNs = this.myDataStartTimeNs + maxTimelineTimeNs;
        long deviceNowUs = TimeUnit.NANOSECONDS.toMicros(deviceNowNs);
        this.myDataRangeUs.setMax(deviceNowUs);
        double viewUs = this.myViewRangeUs.getLength();
        if (this.myStreaming) {
            this.myStreamingFactor = Updater.lerp(this.myStreamingFactor, 1.0f, 0.95f, elapsedNs, Float.MIN_VALUE);
            double min = Updater.lerp(this.myViewRangeUs.getMin(), (double)deviceNowUs - viewUs, this.myStreamingFactor);
            double max = Updater.lerp(this.myViewRangeUs.getMax(), deviceNowUs, this.myStreamingFactor);
            this.myViewRangeUs.set(min, max);
        } else {
            this.myStreamingFactor = 0.0f;
        }
        this.handleZoomView(elapsedNs);
        this.handleJumpToTargetMax(elapsedNs);
    }

    private void handleZoomView(long elapsedNs) {
        if (this.myZoomLeft.getMin() != 0.0 || this.myZoomLeft.getMax() != 0.0) {
            double min = Updater.lerp(0.0, this.myZoomLeft.getMin(), 0.99999f, elapsedNs, 10.0);
            double max = Updater.lerp(0.0, this.myZoomLeft.getMax(), 0.99999f, elapsedNs, 10.0);
            this.myZoomLeft.set(this.myZoomLeft.getMin() - min, this.myZoomLeft.getMax() - max);
            if (this.myViewRangeUs.getMax() + max > this.myDataRangeUs.getMax()) {
                max = this.myDataRangeUs.getMax() - this.myViewRangeUs.getMax();
            }
            this.myViewRangeUs.set(this.myViewRangeUs.getMin() + min, this.myViewRangeUs.getMax() + max);
        }
    }

    private void handleJumpToTargetMax(long elapsedNs) {
        if (this.myTargetRangeMaxUs < 0.0) {
            return;
        }
        this.myJumpFactor = Updater.lerp(this.myJumpFactor, 1.0f, 0.95f, elapsedNs, Float.MIN_VALUE);
        double targetMin = this.myTargetRangeMaxUs - this.myViewRangeUs.getLength();
        double min = Updater.lerp(this.myViewRangeUs.getMin(), targetMin, this.myJumpFactor);
        double max = Updater.lerp(this.myViewRangeUs.getMax(), this.myTargetRangeMaxUs, this.myJumpFactor);
        this.myViewRangeUs.set(min, max);
        if (Double.compare(this.myTargetRangeMaxUs, max) == 0) {
            this.myTargetRangeMaxUs = -1.0;
            this.myJumpFactor = 0.0f;
        }
    }

    private void ensureRangeFitsViewRange(@NotNull Range target) {
        double delta = target.getLength() - this.myViewRangeUs.getLength();
        if (delta > 0.0) {
            this.zoom(delta);
            this.myTargetRangeMaxUs = target.getMax();
        } else if (target.getMax() > this.myViewRangeUs.getMax()) {
            this.myTargetRangeMaxUs = target.getMax();
        } else {
            assert (target.getMin() < this.myViewRangeUs.getMin());
            this.myTargetRangeMaxUs = target.getMin() + this.myViewRangeUs.getLength();
        }
    }

    public void adjustRangeCloseToMiddleView(@NotNull Range target) {
        boolean isTargetLargerThanViewRange;
        boolean targetContainedInViewRange;
        if (target.isEmpty()) {
            return;
        }
        this.setStreaming(false);
        boolean bl = targetContainedInViewRange = this.myViewRangeUs.contains(target.getMin()) && this.myViewRangeUs.contains(target.getMax());
        if (targetContainedInViewRange) {
            return;
        }
        this.ensureRangeFitsViewRange(target);
        boolean bl2 = isTargetLargerThanViewRange = target.getLength() > this.myViewRangeUs.getLength();
        if (isTargetLargerThanViewRange) {
            return;
        }
        double targetMiddle = (target.getMax() + target.getMin()) / 2.0;
        double targetMax = targetMiddle + this.myViewRangeUs.getLength() / 2.0;
        double maxFromZero = this.myDataRangeUs.getMin() + Math.max(target.getLength(), this.myViewRangeUs.getLength());
        targetMax = Math.max(targetMax, maxFromZero);
        this.myTargetRangeMaxUs = Math.min(targetMax, this.myDataRangeUs.getMax());
    }

    public void zoom(double deltaUs, double percent) {
        boolean isDataRangeFullyCoveredByViewRange;
        if (deltaUs == 0.0) {
            return;
        }
        if (deltaUs < 0.0) {
            double zoomMax = -0.9 * this.myViewRangeUs.getLength();
            deltaUs = Math.max(zoomMax, deltaUs);
            if (percent < 1.0 && this.myViewRangeUs.getMin() >= this.myDataRangeUs.getMin()) {
                this.setStreaming(false);
            }
        }
        this.myZoomLeft.clear();
        double minUs = this.myViewRangeUs.getMin() - deltaUs * percent;
        double maxUs = this.myViewRangeUs.getMax() + deltaUs * (1.0 - percent);
        boolean bl = isDataRangeFullyCoveredByViewRange = this.myDataRangeUs.getMin() <= this.myViewRangeUs.getMin();
        if (isDataRangeFullyCoveredByViewRange && minUs < this.myDataRangeUs.getMin()) {
            maxUs += this.myDataRangeUs.getMin() - minUs;
            minUs = this.myDataRangeUs.getMin();
        }
        if (!isDataRangeFullyCoveredByViewRange && minUs < this.myDataRangeUs.getMin()) {
            maxUs = this.myDataRangeUs.getMax();
        }
        if (maxUs > this.myDataRangeUs.getMax()) {
            minUs -= maxUs - this.myDataRangeUs.getMax();
            maxUs = this.myDataRangeUs.getMax();
        }
        if (isDataRangeFullyCoveredByViewRange) {
            minUs = Math.max(minUs, this.myDataRangeUs.getMin());
        }
        this.myZoomLeft.set(minUs - this.myViewRangeUs.getMin(), maxUs - this.myViewRangeUs.getMax());
    }

    @Override
    public void zoomOut() {
        this.zoom(this.myViewRangeUs.getLength() * 0.25);
    }

    public void zoom(double amountUs) {
        this.zoom(amountUs, 0.5);
    }

    @Override
    public void zoomIn() {
        this.zoom(-this.myViewRangeUs.getLength() * 0.25);
    }

    @Override
    public void resetZoom() {
        this.zoom((double)DEFAULT_VIEW_LENGTH_US - this.myViewRangeUs.getLength(), this.isStreaming() ? 1.0 : 0.5);
    }

    @Override
    public void frameViewToRange(Range targetRangeUs) {
        this.frameViewToRange(targetRangeUs, 0.1);
    }

    public void frameViewToRange(Range targetRangeUs, double leftRightPaddingPercent) {
        if (targetRangeUs.isEmpty() || targetRangeUs.isPoint()) {
            this.adjustRangeCloseToMiddleView(targetRangeUs);
            return;
        }
        this.setStreaming(false);
        Range finalRange = new Range(targetRangeUs.getMin() - targetRangeUs.getLength() * leftRightPaddingPercent, targetRangeUs.getMax() + targetRangeUs.getLength() * leftRightPaddingPercent);
        if (finalRange.getMax() > this.myDataRangeUs.getMax()) {
            finalRange.setMax(this.myDataRangeUs.getMax());
        }
        this.myZoomLeft.set(finalRange.getMin() - this.myViewRangeUs.getMin(), finalRange.getMax() - this.myViewRangeUs.getMax());
    }

    @Override
    public void panView(double deltaUs) {
        if (deltaUs < 0.0) {
            this.setStreaming(false);
        }
        Timeline.super.panView(deltaUs);
    }

    public void reset(long startTimeNs, long endTimeNs) {
        this.myDataStartTimeNs = startTimeNs;
        this.myDataLengthNs = endTimeNs - startTimeNs;
        this.myIsPaused = false;
        double startTimeUs = TimeUnit.NANOSECONDS.toMicros(startTimeNs);
        double endTimeUs = TimeUnit.NANOSECONDS.toMicros(endTimeNs);
        this.myDataRangeUs.set(startTimeUs, endTimeUs);
        this.myViewRangeUs.set(endTimeUs - (double)DEFAULT_VIEW_LENGTH_US, endTimeUs);
        this.myTargetRangeMaxUs = -1.0;
        this.myJumpFactor = 0.0f;
        this.myZoomLeft.set(0.0, 0.0);
        this.setStreaming(true);
        this.myResetTimeNs = this.myUpdater.getTimer().getCurrentTimeNs();
        this.myIsReset = true;
    }

    public long getDataStartTimeNs() {
        return this.myDataStartTimeNs;
    }

    public long convertToRelativeTimeUs(long absoluteTimeNs) {
        return TimeUnit.NANOSECONDS.toMicros(absoluteTimeNs - this.myDataStartTimeNs);
    }

    public static enum Aspect {
        STREAMING;

    }
}

