/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiSelectionModel<T>
extends AspectModel<Aspect> {
    private final Set<T> mySelection = new HashSet<T>();

    public ImmutableList<T> getSelection() {
        return ImmutableList.builder().addAll(this.mySelection).build();
    }

    public void setSelection(@NotNull Set<T> newSelection) {
        if (!this.mySelection.containsAll(newSelection) || !newSelection.containsAll(this.mySelection)) {
            this.mySelection.clear();
            this.mySelection.addAll(newSelection);
            this.changed(Aspect.CHANGE_SELECTION);
        }
    }

    public void clearSelection() {
        this.setSelection(Collections.emptySet());
    }

    public boolean isSelected(T selection) {
        return this.mySelection.contains(selection);
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    public static enum Aspect {
        CHANGE_SELECTION;

    }
}

