/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class InstructionsRenderer {
    private int myRowHeight = 0;
    private HorizontalAlignment myAlignment;
    @NotNull
    private final List<RenderInstruction> myInstructions;
    @NotNull
    private final Dimension mySize;
    @NotNull
    private final Map<Integer, Integer> myPerRowWidthMap = new HashMap<Integer, Integer>();

    public InstructionsRenderer(@NotNull List<RenderInstruction> instructions, @NotNull HorizontalAlignment alignment) {
        this.myInstructions = instructions;
        this.myAlignment = alignment;
        for (RenderInstruction instruction : instructions) {
            this.myRowHeight = Math.max(instruction.getSize().height, this.myRowHeight);
        }
        int width = 0;
        int height = 0;
        Point cursor = new Point();
        for (RenderInstruction instruction : instructions) {
            instruction.moveCursor(this, cursor);
            width = Math.max(cursor.x, width);
            height = Math.max(cursor.y + this.myRowHeight, height);
            if (this.myPerRowWidthMap.containsKey(cursor.y) && this.myPerRowWidthMap.get(cursor.y) >= cursor.x) continue;
            this.myPerRowWidthMap.put(cursor.y, cursor.x);
        }
        this.mySize = new Dimension(width, height);
    }

    public int getRowHeight() {
        return this.myRowHeight;
    }

    @NotNull
    public Dimension getRenderSize() {
        return this.mySize;
    }

    @NotNull
    List<RenderInstruction> getInstructions() {
        return this.myInstructions;
    }

    public int getStartX(int y) {
        if (!this.myPerRowWidthMap.containsKey(y)) {
            return 0;
        }
        int rowWidth = this.myPerRowWidthMap.get(y);
        switch (this.myAlignment) {
            case CENTER: {
                return (this.mySize.width - rowWidth) / 2;
            }
            case RIGHT: {
                return this.mySize.width - rowWidth;
            }
        }
        return 0;
    }

    public void draw(@NotNull JComponent component, @NotNull Graphics2D g2d) {
        Point cursor = new Point(this.getStartX(0), 0);
        for (RenderInstruction instruction : this.myInstructions) {
            Rectangle bounds = instruction.getBounds(this, cursor);
            instruction.render(component, g2d, bounds);
            instruction.moveCursor(this, cursor);
        }
    }

    public static enum HorizontalAlignment {
        CENTER(0),
        LEFT(2),
        RIGHT(4);

        private int myAlignment;

        private HorizontalAlignment(int alignment) {
            this.myAlignment = alignment;
        }

        int getAlignment() {
            return this.myAlignment;
        }
    }
}

