/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.flat;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;

public class FlatSeparator
extends JComponent {
    private final Dimension mySize;

    public FlatSeparator(int width, int height) {
        this.mySize = JBUI.size((int)width, (int)height);
    }

    public FlatSeparator() {
        this(6, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mySize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.mySize;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets i = this.getInsets();
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula()) {
            if (this.getParent() != null) {
                JBColor col = new JBColor((Color)Gray._128, (Color)Gray._111);
                Graphics2D g2 = (Graphics2D)g;
                UIUtil.drawDoubleSpaceDottedLine((Graphics2D)g2, (int)(i.top + 2), (int)(this.getParent().getSize().height - 2 - i.top - i.bottom), (int)3, (Color)col, (boolean)false);
            }
        } else {
            g.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            if (this.getParent() != null) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)3.0, (double)2.0, (double)3.0, (double)(this.getParent().getSize().height - 2));
            }
        }
    }
}

