/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class EventIconRenderer<E>
implements EventRenderer<E> {
    private static int BORDER_MARGIN = 2;
    @NotNull
    private Icon myIcon;
    private int myIconWidth;

    public EventIconRenderer(@NotNull Icon icon) {
        this.myIcon = icon;
        this.myIconWidth = this.myIcon.getIconWidth();
    }

    @Override
    public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver, EventAction<E> notUsedData) {
        ImageIcon icon = EventRenderer.createImageIconWithBackgroundBorder(this.myIcon, BORDER_MARGIN, parent.getBackground(), g2d);
        AffineTransform originalTransform = g2d.getTransform();
        g2d.transform(transform);
        icon.paintIcon(parent, g2d, -this.myIconWidth / 2, 0);
        g2d.setTransform(originalTransform);
    }
}

