/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EnumColors<E extends Enum<E>> {
    @NotNull
    private final Map<E, List<Color>> myColors;
    private int myColorIndex;

    public EnumColors(@NotNull Map<E, Color> colors) {
        this.myColors = Maps.newHashMap();
        colors.forEach((e, c) -> this.myColors.put(e, Collections.singletonList(c)));
    }

    private EnumColors(@NotNull Builder<E> builder) {
        this.myColors = ((Builder)builder).myColors;
    }

    @NotNull
    public Color getColor(@NotNull E type) {
        List<Color> colorList = this.myColors.get(type);
        if (colorList == null) {
            throw new IllegalStateException("No colors for value " + type);
        }
        return colorList.get(this.myColorIndex % colorList.size());
    }

    public void setColorIndex(int colorIndex) {
        this.myColorIndex = colorIndex;
    }

    public static final class Builder<E extends Enum<E>> {
        private final int myNumColorsPerType;
        private Map<E, List<Color>> myColors = Maps.newHashMap();

        public Builder(int numColorsPerType) {
            this.myNumColorsPerType = numColorsPerType;
        }

        @NotNull
        public Builder<E> add(@NotNull E type, Color ... colors) {
            if (colors.length != this.myNumColorsPerType) {
                throw new IllegalArgumentException(String.format("Attempting to initialize colors for %1$s with %2$d color(s), should be %3$d", type, colors.length, this.myNumColorsPerType));
            }
            this.myColors.put(type, Arrays.asList(colors));
            return this;
        }

        @NotNull
        public EnumColors<E> build() {
            return new EnumColors(this);
        }
    }
}

