/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.DataVisualizationTheme;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u000e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0018J\u0016\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0013J\u001e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0018J\u001e\u0010!\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0013J:\u0010&\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00132\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0(H\u0002J:\u0010&\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00132\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0(H\u0002J\u000e\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010+\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0004J\u0010\u0010,\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010.\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R9\u0010\t\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR9\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lcom/android/tools/adtui/common/DataVisualizationColors;", "", "()V", "BACKGROUND_DATA_COLOR", "", "DEFAULT_DARK_TEXT_COLOR", "Ljava/awt/Color;", "DEFAULT_LIGHT_TEXT_COLOR", "PRIMARY_DATA_COLOR", "dataPalette", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/ui/JBColor;", "Lkotlin/collections/LinkedHashMap;", "getDataPalette", "()Ljava/util/LinkedHashMap;", "fontPalette", "getFontPalette", "isInitialized", "", "()Z", "setInitialized", "(Z)V", "numberOfTonesPerColor", "", "getNumberOfTonesPerColor", "()I", "setNumberOfTonesPerColor", "(I)V", "doInitialize", "", "paletteStream", "Ljava/io/InputStream;", "getColor", "index", "isFocused", "toneIndex", "name", "getColorFromPalette", "palette", "", "getFocusColor", "color", "getFontColor", "initialize", "loadColorPalette", "toGrayscale", "intellij.android.adt.ui"})
public final class DataVisualizationColors {
    @NotNull
    public static final String PRIMARY_DATA_COLOR = "Vivid Blue";
    @NotNull
    public static final String BACKGROUND_DATA_COLOR = "Gray";
    @JvmField
    @NotNull
    public static final Color DEFAULT_LIGHT_TEXT_COLOR;
    @JvmField
    @NotNull
    public static final Color DEFAULT_DARK_TEXT_COLOR;
    @NotNull
    private static final LinkedHashMap<String, List<JBColor>> dataPalette;
    @NotNull
    private static final LinkedHashMap<String, List<JBColor>> fontPalette;
    private static int numberOfTonesPerColor;
    private static boolean isInitialized;
    public static final DataVisualizationColors INSTANCE;

    @NotNull
    public final LinkedHashMap<String, List<JBColor>> getDataPalette() {
        return dataPalette;
    }

    @NotNull
    public final LinkedHashMap<String, List<JBColor>> getFontPalette() {
        return fontPalette;
    }

    public final int getNumberOfTonesPerColor() {
        return numberOfTonesPerColor;
    }

    public final void setNumberOfTonesPerColor(int n) {
        numberOfTonesPerColor = n;
    }

    public final boolean isInitialized() {
        return isInitialized;
    }

    public final void setInitialized(boolean bl) {
        isInitialized = bl;
    }

    public final void initialize(@NotNull InputStream paletteStream) {
        if (isInitialized) {
            return;
        }
        this.doInitialize(paletteStream);
    }

    public static /* synthetic */ void initialize$default(DataVisualizationColors dataVisualizationColors, InputStream inputStream, int n, Object object) {
        if ((n & 1) != 0) {
            inputStream = dataVisualizationColors.getClass().getResourceAsStream("/palette/data-visualization-palette.json");
        }
        dataVisualizationColors.initialize(inputStream);
    }

    @VisibleForTesting
    public final void doInitialize(@NotNull InputStream paletteStream) {
        this.loadColorPalette(paletteStream);
        numberOfTonesPerColor = ((List)CollectionsKt.first((Iterable)dataPalette.values())).size();
        isInitialized = true;
    }

    @NotNull
    public final JBColor getColor(int index) {
        return this.getColor(index, false);
    }

    @NotNull
    public final JBColor getColor(int index, boolean isFocused) {
        return this.getColor(index, 0, isFocused);
    }

    @NotNull
    public final JBColor getColor(int index, int toneIndex, boolean isFocused) {
        return this.getColorFromPalette(index, toneIndex, isFocused, (Map<String, ? extends List<? extends JBColor>>)dataPalette);
    }

    @NotNull
    public final JBColor getColor(@NotNull String name, int toneIndex) {
        return this.getColor(name, toneIndex, false);
    }

    @NotNull
    public final JBColor getColor(@NotNull String name, boolean isFocused) {
        return this.getColor(name, 0, isFocused);
    }

    @NotNull
    public final JBColor getColor(@NotNull String name, int toneIndex, boolean isFocused) {
        return this.getColorFromPalette(name, toneIndex, isFocused, (Map<String, ? extends List<? extends JBColor>>)dataPalette);
    }

    @NotNull
    public final JBColor getFocusColor(@NotNull JBColor color) {
        return new JBColor(color.brighter(), color.darker());
    }

    @NotNull
    public final JBColor getFontColor(int index) {
        return this.getColorFromPalette(index, 0, false, (Map<String, ? extends List<? extends JBColor>>)fontPalette);
    }

    @NotNull
    public final JBColor getFontColor(@NotNull String name) {
        return this.getColorFromPalette(name, 0, false, (Map<String, ? extends List<? extends JBColor>>)fontPalette);
    }

    @NotNull
    public final Color toGrayscale(@NotNull Color color) {
        float avg = 0.3f * (float)color.getRed() / 255.0f + 0.59f * (float)color.getBlue() / 255.0f + 0.11f * (float)color.getGreen() / 255.0f;
        return new Color(avg, avg, avg);
    }

    private final JBColor getColorFromPalette(int index, int toneIndex, boolean isFocused, Map<String, ? extends List<? extends JBColor>> palette) {
        if (!isInitialized) {
            DataVisualizationColors.initialize$default(this, null, 1, null);
        }
        int n = index + numberOfTonesPerColor * toneIndex;
        boolean bl = false;
        int boundIndex = Math.abs(n) % (palette.size() * numberOfTonesPerColor);
        int colorIndex = boundIndex % palette.size();
        int toneIndex2 = boundIndex / palette.size() % numberOfTonesPerColor;
        JBColor color = (JBColor)((List)CollectionsKt.elementAt((Iterable)palette.values(), (int)colorIndex)).get(toneIndex2);
        return isFocused ? this.getFocusColor(color) : color;
    }

    private final JBColor getColorFromPalette(String name, int toneIndex, boolean isFocused, Map<String, ? extends List<? extends JBColor>> palette) {
        if (!isInitialized) {
            DataVisualizationColors.initialize$default(this, null, 1, null);
        }
        boolean bl = palette.containsKey(name);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Palette does not contain specified key: " + name + '.';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<? extends JBColor> list = palette.get(name);
        if (list == null) {
            Intrinsics.throwNpe();
        }
        JBColor color = list.get(toneIndex);
        return isFocused ? this.getFocusColor(color) : color;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadColorPalette(InputStream paletteStream) {
        DataVisualizationTheme[] colors;
        Gson gsonParser = new Gson();
        DataVisualizationTheme[] $this$forEach$iv = colors = (DataVisualizationTheme[])gsonParser.fromJson((Reader)new InputStreamReader(paletteStream), DataVisualizationTheme[].class);
        boolean $i$f$forEach = false;
        DataVisualizationTheme[] dataVisualizationThemeArray = $this$forEach$iv;
        int n = dataVisualizationThemeArray.length;
        for (int i = 0; i < n; ++i) {
            int idx;
            int n2;
            DataVisualizationTheme element$iv;
            DataVisualizationTheme it = element$iv = dataVisualizationThemeArray[i];
            boolean bl = false;
            boolean bl2 = it.getLight().size() == it.getDark().size();
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-DataVisualizationColors$loadColorPalette$1$22 = false;
                String $i$a$-assert-DataVisualizationColors$loadColorPalette$1$22 = "Expected light (" + it.getLight().size() + "), and dark (" + it.getDark().size() + ") palette to have same number of colors";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DataVisualizationColors$loadColorPalette$1$22));
            }
            bl3 = false;
            List dataColors = new ArrayList();
            Iterable $this$forEachIndexed$iv22 = it.getLight();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv22) {
                void color;
                int n3 = index$iv++;
                n2 = 0;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                idx = n3;
                boolean bl4 = false;
                dataColors.add(new JBColor(Integer.parseInt((String)color, 16), Integer.parseInt(it.getDark().get(idx), 16)));
            }
            ((Map)dataPalette).put(it.getName(), dataColors);
            boolean $this$forEachIndexed$iv22 = it.getLightModeDarkText().size() == it.getLight().size();
            $i$f$forEachIndexed = false;
            if (_Assertions.ENABLED && !$this$forEachIndexed$iv22) {
                boolean $i$a$-assert-DataVisualizationColors$loadColorPalette$1$52 = false;
                String $i$a$-assert-DataVisualizationColors$loadColorPalette$1$52 = "Expected font (" + it.getLightModeDarkText().size() + "), and data (" + it.getLight().size() + ") palette to have same number of colors";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DataVisualizationColors$loadColorPalette$1$52));
            }
            $this$forEachIndexed$iv22 = it.getLightModeDarkText().size() == it.getDarkModeLightText().size();
            $i$f$forEachIndexed = false;
            if (_Assertions.ENABLED && !$this$forEachIndexed$iv22) {
                boolean $i$a$-assert-DataVisualizationColors$loadColorPalette$1$62 = false;
                String $i$a$-assert-DataVisualizationColors$loadColorPalette$1$62 = "Expected light (" + it.getLightModeDarkText().size() + "), and dark (" + it.getDarkModeLightText().size() + ") palette to have same number of font colors";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DataVisualizationColors$loadColorPalette$1$62));
            }
            $i$f$forEachIndexed = false;
            List fontColors = new ArrayList();
            Iterable $this$forEachIndexed$iv = it.getLightModeDarkText();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void lightModeDarkText;
                n2 = index$iv2++;
                boolean bl5 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                idx = ((Boolean)item$iv).booleanValue() ? 1 : 0;
                int idx2 = n2;
                boolean bl6 = false;
                Color lightModeColor = lightModeDarkText != false ? DEFAULT_DARK_TEXT_COLOR : DEFAULT_LIGHT_TEXT_COLOR;
                Color darkModeColor = it.getDarkModeLightText().get(idx2) != false ? DEFAULT_LIGHT_TEXT_COLOR : DEFAULT_DARK_TEXT_COLOR;
                fontColors.add(new JBColor(lightModeColor, darkModeColor));
            }
            ((Map)fontPalette).put(it.getName(), fontColors);
        }
    }

    private DataVisualizationColors() {
    }

    static {
        DataVisualizationColors dataVisualizationColors;
        INSTANCE = dataVisualizationColors = new DataVisualizationColors();
        DEFAULT_LIGHT_TEXT_COLOR = Color.WHITE;
        DEFAULT_DARK_TEXT_COLOR = Color.BLACK;
        dataPalette = new LinkedHashMap();
        fontPalette = new LinkedHashMap();
    }
}

