/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.intellij.icons.AllIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ZoomType {
    FIT("Zoom to Fit Screen", AllIcons.General.FitContent, AllIcons.General.FitContent),
    FIT_INTO("Zoom out to Fit Screen", AllIcons.General.FitContent, null),
    ACTUAL("100%", null, AllIcons.General.ActualZoom),
    IN("Zoom In", AllIcons.General.ZoomIn, AllIcons.General.Add),
    OUT("Zoom Out", AllIcons.General.ZoomOut, AllIcons.General.Remove),
    SCREEN("Exact Device Size", null, null);

    private final String myLabel;
    private final Icon myIcon;
    private final Icon myFloatingIcon;
    private static final int[] ZOOM_POINTS;

    private ZoomType(@Nullable String label2, Icon normalIcon, Icon floatingIcon) {
        this.myLabel = label2;
        this.myIcon = normalIcon;
        this.myFloatingIcon = floatingIcon;
    }

    public String getLabel() {
        return this.myLabel;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getFloatingIcon() {
        return this.myFloatingIcon;
    }

    public boolean showInMenu() {
        return this != FIT_INTO && this != SCREEN;
    }

    public String toString() {
        return this.getLabel();
    }

    public static int zoomIn(int percentage) {
        return ZoomType.zoomIn(percentage, ZOOM_POINTS);
    }

    public static int zoomIn(int percentage, @NotNull int[] zoomPoints) {
        int i = Arrays.binarySearch(zoomPoints, percentage);
        if (i < 0) {
            if ((i = -i - 1) == 0 && (double)percentage < (double)zoomPoints[0] * 0.75) {
                return Math.min((int)Math.ceil((double)percentage * 1.2), zoomPoints[0]);
            }
            if (i < zoomPoints.length) {
                return zoomPoints[i];
            }
            return (percentage / 100 + 1) * 100;
        }
        if (i < zoomPoints.length - 1) {
            return zoomPoints[i + 1];
        }
        return percentage + 100;
    }

    public static int zoomOut(int percentage) {
        return ZoomType.zoomOut(percentage, ZOOM_POINTS);
    }

    public static int zoomOut(int percentage, @NotNull int[] zoomPoints) {
        int i = Arrays.binarySearch(zoomPoints, percentage);
        if (i < 0) {
            if ((i = -i - 1) == 0) {
                return (int)Math.floor((double)percentage / 1.1);
            }
            if (i < zoomPoints.length) {
                return zoomPoints[i - 1];
            }
            return (percentage / 100 - 1) * 100;
        }
        if (i > 0) {
            return zoomPoints[i - 1];
        }
        return (int)Math.floor((double)percentage / 1.1);
    }

    static {
        ZOOM_POINTS = new int[]{25, 33, 50, 67, 75, 90, 100, 110, 125, 150, 200};
    }
}

