/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.annotations.concurrency.Slow;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtils {
    public static final double EPSILON = 1.0E-5;
    public static final int RETINA_SCALE = 2;
    public static final CropFilter TRANSPARENCY_FILTER = (bufferedImage, x, y) -> {
        int rgb = bufferedImage.getRGB(x, y);
        return (rgb & 0xFF000000) == 0;
    };
    private static boolean ourRetinaCapable = true;

    public static BufferedImage rotateByRightAngle(BufferedImage source, int degrees) {
        int h1;
        int w1;
        assert (degrees % 90 == 0);
        int w = source.getWidth();
        int h = source.getHeight();
        switch (degrees %= 360) {
            case 90: 
            case 270: {
                w1 = h;
                h1 = w;
                break;
            }
            default: {
                w1 = w;
                h1 = h;
            }
        }
        ColorModel model2 = source.getColorModel();
        WritableRaster raster = model2.createCompatibleWritableRaster(w1, h1);
        BufferedImage rotated = new BufferedImage(model2, raster, source.isAlphaPremultiplied(), null);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int y1;
                int x1;
                int v = source.getRGB(x, y);
                switch (degrees) {
                    case 90: {
                        x1 = h - y - 1;
                        y1 = x;
                        break;
                    }
                    case 180: {
                        x1 = w - x - 1;
                        y1 = h - y - 1;
                        break;
                    }
                    case 270: {
                        x1 = y;
                        y1 = w - x - 1;
                        break;
                    }
                    default: {
                        x1 = x;
                        y1 = y;
                    }
                }
                rotated.setRGB(x1, y1, v);
            }
        }
        return rotated;
    }

    @NotNull
    public static BufferedImage rotateByQuadrants(@NotNull BufferedImage source, int numQuadrants) {
        int shiftY;
        int shiftX;
        int rotatedH;
        int rotatedW;
        if (numQuadrants % 4 == 0) {
            return source;
        }
        while (numQuadrants < 0) {
            numQuadrants += 4;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        switch (numQuadrants %= 4) {
            default: {
                rotatedW = w;
                rotatedH = h;
                shiftX = 0;
                shiftY = 0;
                break;
            }
            case 1: {
                rotatedW = h;
                rotatedH = w;
                shiftX = 0;
                shiftY = w;
                break;
            }
            case 2: {
                rotatedW = w;
                rotatedH = h;
                shiftX = w;
                shiftY = h;
                break;
            }
            case 3: {
                rotatedW = h;
                rotatedH = w;
                shiftX = h;
                shiftY = 0;
            }
        }
        BufferedImage result = new BufferedImage(rotatedW, rotatedH, source.getType());
        AffineTransform transform = new AffineTransform();
        transform.translate(shiftX, shiftY);
        transform.quadrantRotate(-numQuadrants);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 1);
        return transformOp.filter(source, result);
    }

    @NotNull
    public static BufferedImage rotateByQuadrantsAndScale(@NotNull BufferedImage source, int numQuadrants, int destinationWidth, int destinationHeight) {
        int shiftY;
        int shiftX;
        double rotatedH;
        double rotatedW;
        if (numQuadrants % 4 == 0 && destinationWidth == source.getWidth() && destinationHeight == source.getHeight()) {
            return source;
        }
        while (numQuadrants < 0) {
            numQuadrants += 4;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        switch (numQuadrants %= 4) {
            default: {
                rotatedW = w;
                rotatedH = h;
                shiftX = 0;
                shiftY = 0;
                break;
            }
            case 1: {
                rotatedW = h;
                rotatedH = w;
                shiftX = 0;
                shiftY = destinationHeight;
                break;
            }
            case 2: {
                rotatedW = w;
                rotatedH = h;
                shiftX = destinationWidth;
                shiftY = destinationHeight;
                break;
            }
            case 3: {
                rotatedW = h;
                rotatedH = w;
                shiftX = destinationWidth;
                shiftY = 0;
            }
        }
        BufferedImage result = new BufferedImage(destinationWidth, destinationHeight, source.getType());
        AffineTransform transform = new AffineTransform();
        transform.translate(shiftX, shiftY);
        transform.scale((double)destinationWidth / rotatedW, (double)destinationHeight / rotatedH);
        transform.quadrantRotate(-numQuadrants);
        AffineTransformOp transformOp = new AffineTransformOp(transform, 2);
        return transformOp.filter(source, result);
    }

    public static boolean isRetinaImage(@Nullable BufferedImage image) {
        return image instanceof JBHiDPIScaledImage;
    }

    public static BufferedImage createDipImage(int width, int height, int type) {
        return ImageUtil.createImage((int)width, (int)height, (int)type);
    }

    public static boolean supportsRetina() {
        return ourRetinaCapable;
    }

    @Nullable
    public static BufferedImage convertToRetina(@NotNull BufferedImage image) {
        return ImageUtils.convertToRetina(image, null);
    }

    @Nullable
    public static BufferedImage convertToRetina(@NotNull BufferedImage image, @Nullable ScaleContext ctx) {
        if (image.getWidth() < 2 || image.getHeight() < 2) {
            return null;
        }
        try {
            Image retina = RetinaImage.createFrom((Image)image, (double)JBUIScale.sysScale((ScaleContext)ctx), null);
            if (!(retina instanceof BufferedImage)) {
                ourRetinaCapable = false;
                return null;
            }
            return (BufferedImage)retina;
        }
        catch (Throwable ignored) {
            ourRetinaCapable = false;
            return null;
        }
    }

    @NotNull
    public static BufferedImage convertToRetinaIgnoringFailures(@NotNull BufferedImage image) {
        BufferedImage retina;
        if (ImageUtils.supportsRetina() && (retina = ImageUtils.convertToRetina(image)) != null) {
            return retina;
        }
        return image;
    }

    public static void drawDipImage(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(0, 0, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
    }

    public static BufferedImage addMargin(BufferedImage source, int marginSize) {
        int destWidth = source.getWidth() + 2 * marginSize;
        int destHeight = source.getHeight() + 2 * marginSize;
        int type = source.getColorModel().hasAlpha() ? source.getType() : 2;
        BufferedImage expanded = new BufferedImage(destWidth, destHeight, type);
        Graphics2D g2 = expanded.createGraphics();
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth, destHeight);
        g2.drawImage((Image)source, marginSize, marginSize, null);
        g2.dispose();
        return expanded;
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double amount) {
        return ImageUtils.scale(source, amount, amount, 0, 0);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, @Nullable Shape clip) {
        return ImageUtils.scale(source, xScale, yScale, 0, 0, clip);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin) {
        return ImageUtils.scale(source, xScale, yScale, rightMargin, bottomMargin, null);
    }

    @NotNull
    public static BufferedImage scale(BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, @Nullable Shape clip) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0 || imageType == 13 || imageType == 12) {
            imageType = 2;
        }
        if (xScale > 0.5 && yScale > 0.5) {
            BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
            Graphics2D g2 = scaled.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setColor(new Color(0, true));
            g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
            if (clip != null) {
                g2.setClip(clip);
            }
            if (xScale == 1.0 && yScale == 1.0) {
                g2.drawImage((Image)source, 0, 0, null);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
            }
            g2.dispose();
            return scaled;
        }
        int iterations = 0;
        int nearestWidth = destWidth;
        int nearestHeight = destHeight;
        while (nearestWidth < sourceWidth / 2) {
            nearestWidth *= 2;
            nearestHeight *= 2;
            ++iterations;
        }
        if (iterations == 0) {
            nearestWidth += rightMargin;
            nearestHeight += bottomMargin;
        }
        BufferedImage scaled = new BufferedImage(nearestWidth, nearestHeight, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(source, 0, 0, nearestWidth, nearestHeight, 0, 0, sourceWidth, sourceHeight, null);
        g2.dispose();
        sourceWidth = nearestWidth;
        sourceHeight = nearestHeight;
        source = scaled;
        for (int iteration = iterations - 1; iteration >= 0; --iteration) {
            int halfWidth = sourceWidth / 2;
            int halfHeight = sourceHeight / 2;
            if (iteration == 0) {
                scaled = new BufferedImage(halfWidth + rightMargin, halfHeight + bottomMargin, imageType);
                g2 = scaled.createGraphics();
                if (clip != null) {
                    g2.setClip(clip);
                }
            } else {
                scaled = new BufferedImage(halfWidth, halfHeight, imageType);
                g2 = scaled.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(source, 0, 0, halfWidth, halfHeight, 0, 0, sourceWidth, sourceHeight, null);
            g2.dispose();
            sourceWidth = halfWidth;
            sourceHeight = halfHeight;
            source = scaled;
            --iterations;
        }
        return scaled;
    }

    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double yScale) {
        return ImageUtils.lowQualityFastScale(source, xScale, yScale, 0, 0, null);
    }

    @NotNull
    public static BufferedImage lowQualityFastScale(@NotNull BufferedImage source, double xScale, double yScale, int rightMargin, int bottomMargin, @Nullable Shape clip) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int destWidth = Math.max(1, (int)(xScale * (double)sourceWidth));
        int destHeight = Math.max(1, (int)(yScale * (double)sourceHeight));
        int imageType = source.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage scaled = new BufferedImage(destWidth + rightMargin, destHeight + bottomMargin, imageType);
        Graphics2D g2 = scaled.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(0, true));
        g2.fillRect(0, 0, destWidth + rightMargin, destHeight + bottomMargin);
        if (clip != null) {
            g2.setClip(clip);
        }
        if (xScale == 1.0 && yScale == 1.0) {
            g2.drawImage((Image)source, 0, 0, null);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
        }
        g2.dispose();
        return scaled;
    }

    @Slow
    @Nullable
    public static BufferedImage readImageAtScale(InputStream inputStream, Dimension dimension) throws IOException {
        double scale;
        ImageInputStream imageStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> readerIterator = ImageIO.getImageReaders(imageStream);
        if (!readerIterator.hasNext()) {
            return null;
        }
        ImageReader reader = readerIterator.next();
        reader.setInput(imageStream);
        ImageReadParam readParams = reader.getDefaultReadParam();
        double srcW = reader.getWidth(0);
        double srcH = reader.getHeight(0);
        double d = scale = srcW > srcH ? (double)dimension.width / srcW : (double)dimension.height / srcH;
        if (scale < 0.5) {
            double xStep = Math.floor(1.0 / (scale *= 2.0));
            double yStep = Math.floor(1.0 / scale);
            readParams.setSourceSubsampling((int)xStep, (int)yStep, 0, 0);
        }
        BufferedImage intermediateImage = reader.read(0, readParams);
        imageStream.close();
        inputStream.close();
        double finalScale = srcW > srcH ? (double)dimension.width / (double)intermediateImage.getWidth() : (double)dimension.height / (double)intermediateImage.getHeight();
        return ImageUtils.scale(intermediateImage, finalScale, finalScale);
    }

    @Nullable
    public static BufferedImage cropBlank(@NotNull BufferedImage image, @Nullable Rectangle initialCrop) {
        return ImageUtils.cropBlank(image, initialCrop, image.getType());
    }

    @Nullable
    public static BufferedImage cropBlank(@Nullable BufferedImage image, @Nullable Rectangle initialCrop, int imageType) {
        return ImageUtils.crop(image, TRANSPARENCY_FILTER, initialCrop, imageType);
    }

    @Nullable
    public static Rectangle getCropBounds(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop) {
        int y;
        int x;
        int y2;
        int x2;
        int y1;
        int x1;
        if (image == null) {
            return null;
        }
        if (initialCrop != null) {
            x1 = Math.max(initialCrop.x, 0);
            y1 = Math.max(initialCrop.y, 0);
            x2 = Math.min(initialCrop.x + initialCrop.width, image.getWidth());
            y2 = Math.min(initialCrop.y + initialCrop.height, image.getHeight());
        } else {
            x1 = 0;
            y1 = 0;
            x2 = image.getWidth();
            y2 = image.getHeight();
        }
        if (x1 == x2 || y1 == y2) {
            return null;
        }
        block0: while (y1 < y2) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y1)) break block0;
            }
            ++y1;
        }
        if (y1 == y2) {
            return null;
        }
        block2: while (x1 < x2) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x1, y)) break block2;
            }
            ++x1;
        }
        block4: while (--x2 >= x1) {
            for (y = y1; y < y2; ++y) {
                if (!filter.crop(image, x2, y)) break block4;
            }
        }
        ++x2;
        block6: while (--y2 >= y1) {
            for (x = x1; x < x2; ++x) {
                if (!filter.crop(image, x, y2)) break block6;
            }
        }
        if (x1 == x2 || y1 == ++y2) {
            return null;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }

    @Nullable
    public static BufferedImage crop(@Nullable BufferedImage image, @NotNull CropFilter filter, @Nullable Rectangle initialCrop, int imageType) {
        if (image == null) {
            return null;
        }
        Rectangle cropBounds = ImageUtils.getCropBounds(image, filter, initialCrop);
        if (cropBounds == null) {
            return null;
        }
        return ImageUtils.getCroppedImage(image, cropBounds, imageType);
    }

    @NotNull
    public static BufferedImage getCroppedImage(@NotNull BufferedImage image, @NotNull Rectangle cropBounds, int imageType) {
        int x1 = cropBounds.x;
        int y1 = cropBounds.y;
        int width = cropBounds.width;
        int height = cropBounds.height;
        int x2 = x1 + width;
        int y2 = y1 + height;
        if (imageType == -1) {
            imageType = image.getType();
        }
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage cropped = new BufferedImage(width, height, imageType);
        Graphics g = cropped.getGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return cropped;
    }

    public static boolean isNonOpaque(@NotNull BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000 ^ 0xFF000000) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static double calcFullyDisplayZoomFactor(double viewHeight, double viewWidth, double imageHeight, double imageWidth) {
        assert (imageHeight != 0.0 && imageWidth != 0.0);
        return Math.min(viewHeight / imageHeight / 1.1, viewWidth / imageWidth / 1.1);
    }

    public static BufferedImage iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ImageUtil.toBufferedImage((Image)((ImageIcon)icon).getImage());
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = ImageUtil.createImage((int)w, (int)h, (int)6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static interface CropFilter {
        public boolean crop(BufferedImage var1, int var2, int var3);
    }
}

