/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StatusType {
    INAPPLICABLE("inapplicable"),
    UNKNOWN("unknown"),
    UNCHANGED("unchanged"),
    MISSING("missing"),
    OBSTRUCTED("obstructed"),
    CHANGED("changed"),
    MERGED("merged"),
    CONFLICTED("conflicted"),
    STATUS_NONE("none"),
    STATUS_NORMAL("normal", ' '),
    STATUS_MODIFIED("modified", 'M'),
    STATUS_ADDED("added", 'A'),
    STATUS_DELETED("deleted", 'D'),
    STATUS_UNVERSIONED("unversioned", '?'),
    STATUS_MISSING("missing", '!'),
    STATUS_REPLACED("replaced", 'R'),
    STATUS_CONFLICTED("conflicted", 'C'),
    STATUS_OBSTRUCTED("obstructed", '~'),
    STATUS_IGNORED("ignored", 'I'),
    STATUS_INCOMPLETE("incomplete", '!'),
    STATUS_EXTERNAL("external", 'X');

    private static final String STATUS_PREFIX = "STATUS_";
    @NotNull
    private static final Map<String, StatusType> ourOtherStatusTypes;
    @NotNull
    private static final Map<String, StatusType> ourStatusTypesForStatusOperation;
    private final String myName;
    private final char myCode;

    private StatusType(String name) {
        this(name, ' ');
    }

    private StatusType(String name, char code) {
        this.myName = name;
        this.myCode = code;
    }

    public char getCode() {
        return this.myCode;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull StatusType action) {
        (action.name().startsWith(STATUS_PREFIX) ? ourStatusTypesForStatusOperation : ourOtherStatusTypes).put(action.myName, action);
    }

    @Nullable
    public static StatusType forStatusOperation(@NotNull String statusName) {
        return ourStatusTypesForStatusOperation.get(statusName);
    }

    static {
        ourOtherStatusTypes = new HashMap<String, StatusType>();
        ourStatusTypesForStatusOperation = new HashMap<String, StatusType>();
        for (StatusType action : StatusType.values()) {
            StatusType.register(action);
        }
    }
}

