/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance(SvnMergeInfoCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Url, MyCurrentUrlData> myCurrentUrlMapping;
    public static final Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(@NotNull Project project) {
        this.myProject = project;
        this.myCurrentUrlMapping = new HashMap<Url, MyCurrentUrlData>();
    }

    public static SvnMergeInfoCache getInstance(@NotNull Project project) {
        return (SvnMergeInfoCache)ServiceManager.getService((Project)project, SvnMergeInfoCache.class);
    }

    public void clear(@NotNull WCInfoWithBranches info2, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info2, branchPath);
        if (branchInfo != null) {
            branchInfo.clear();
        }
    }

    @Nullable
    public MergeInfoCached getCachedState(@NotNull WCInfoWithBranches info2, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info2, branchPath);
        return branchInfo != null ? branchInfo.getCached() : null;
    }

    public MergeCheckResult getState(@NotNull WCInfoWithBranches info2, @NotNull SvnChangeList list, @NotNull WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info2.getUrl());
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myCurrentUrlMapping.put(info2.getUrl(), rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info2, selectedBranch);
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(@NotNull WCInfoWithBranches info2, String branchPath) {
        BranchInfo branchInfo = this.getBranchInfo(info2, branchPath);
        return branchInfo != null && branchInfo.isMixedRevisionsFound();
    }

    @Nullable
    private BranchInfo getBranchInfo(@NotNull WCInfoWithBranches info2, String branchPath) {
        MyCurrentUrlData rootMapping = this.myCurrentUrlMapping.get(info2.getUrl());
        return rootMapping != null ? rootMapping.getBranchInfo(branchPath) : null;
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        @NotNull
        private final Map<String, BranchInfo> myBranchInfo = ContainerUtil.createSoftMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(@NotNull String branchUrl, @NotNull BranchInfo mergeChecker) {
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }
    }

    static class CopyRevison {
        private final String myPath;
        private volatile long myRevision;

        CopyRevison(final SvnVcs vcs, String path, final @NotNull Url repositoryRoot, final @NotNull Url branchUrl, final @NotNull Url trunkUrl) {
            this.myPath = path;
            this.myRevision = -1L;
            Task.Backgroundable task = new Task.Backgroundable(vcs.getProject(), "Calculating Copy Revision", false){
                private CopyData myData;

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        this.myData = new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl).run();
                    }
                    catch (VcsException e) {
                        this.logAndShow(e);
                    }
                }

                public void onSuccess() {
                    if (this.myData != null) {
                        myRevision = this.myData.getCopySourceRevision();
                        if (myRevision != -1L) {
                            ((SvnMergeInfoCacheListener)BackgroundTaskUtil.syncPublisher((Project)vcs.getProject(), SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    this.logAndShow(error);
                }

                private void logAndShow(@NotNull Throwable error) {
                    LOG.info(error);
                    VcsBalloonProblemNotifier.showOverChangesView((Project)vcs.getProject(), (String)error.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new EmptyProgressIndicator());
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }
}

