/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.MergeRangeList;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;

public class OneShotMergeInfoHelper
implements MergeChecker {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Map<Long, Collection<String>> myPartiallyMerged;
    @NotNull
    private final NavigableMap<String, Map<String, MergeRangeList>> myMergeInfoMap;
    @NotNull
    private final Object myMergeInfoLock;

    public OneShotMergeInfoHelper(@NotNull MergeContext mergeContext) {
        this.myMergeContext = mergeContext;
        this.myPartiallyMerged = new HashMap<Long, Collection<String>>();
        this.myMergeInfoLock = new Object();
        this.myMergeInfoMap = new TreeMap(Collections.reverseOrder());
    }

    @Override
    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        File file = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        this.myMergeContext.getVcs().getFactory(file).createPropertyClient().getProperty(Target.on(file), "svn:mergeinfo", Revision.WORKING, depth, this.createPropertyHandler());
    }

    @Override
    @Nullable
    public Collection<String> getNotMergedPaths(@NotNull SvnChangeList changeList) {
        return this.myPartiallyMerged.get(changeList.getNumber());
    }

    @Override
    @NotNull
    public MergeCheckResult checkList(@NotNull SvnChangeList changeList) {
        HashSet<String> notMergedPaths = new HashSet<String>();
        boolean hasMergedPaths = false;
        for (String path : changeList.getAffectedPaths()) {
            switch (this.checkPath(path, changeList.getNumber())) {
                case MERGED: {
                    hasMergedPaths = true;
                    break;
                }
                case NOT_MERGED: {
                    notMergedPaths.add(path);
                }
            }
        }
        if (hasMergedPaths && !notMergedPaths.isEmpty()) {
            this.myPartiallyMerged.put(changeList.getNumber(), notMergedPaths);
        }
        return notMergedPaths.isEmpty() ? (hasMergedPaths ? MergeCheckResult.MERGED : MergeCheckResult.NOT_EXISTS) : MergeCheckResult.NOT_MERGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MergeCheckResult checkPath(@NotNull String repositoryRelativePath, long revisionNumber) {
        MergeCheckResult result = MergeCheckResult.NOT_EXISTS;
        String sourceRelativePath = Url.getRelative(this.myMergeContext.getRepositoryRelativeSourcePath(), SvnUtil.ensureStartSlash(repositoryRelativePath));
        if (sourceRelativePath != null) {
            InfoProcessor processor = new InfoProcessor(sourceRelativePath, this.myMergeContext.getRepositoryRelativeSourcePath(), revisionNumber);
            String key = OneShotMergeInfoHelper.toKey(sourceRelativePath);
            Object object = this.myMergeInfoLock;
            synchronized (object) {
                Map mergeInfo = (Map)this.myMergeInfoMap.get(key);
                if (mergeInfo != null) {
                    processor.process(key, mergeInfo);
                } else {
                    Map.Entry<String, Map<String, MergeRangeList>> entry;
                    Iterator<Map.Entry<String, Map<String, MergeRangeList>>> iterator = this.myMergeInfoMap.tailMap(key).entrySet().iterator();
                    while (!(!iterator.hasNext() || OneShotMergeInfoHelper.isUnder((entry = iterator.next()).getKey(), key) && processor.process(entry.getKey(), entry.getValue()))) {
                    }
                }
            }
            result = MergeCheckResult.getInstance(processor.isMerged());
        }
        return result;
    }

    private static boolean isUnder(@NotNull String parentUrl, @NotNull String childUrl) {
        return ".".equals(parentUrl) || Url.isAncestor(SvnUtil.ensureStartSlash(parentUrl), SvnUtil.ensureStartSlash(childUrl));
    }

    @NotNull
    private PropertyConsumer createPropertyHandler() {
        return new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(@NotNull File path, @NotNull PropertyData property) throws SvnBindException {
                String workingCopyRelativePath = OneShotMergeInfoHelper.this.getWorkingCopyRelativePath(path);
                Map<String, MergeRangeList> mergeInfo = MergeRangeList.parseMergeInfo(Objects.requireNonNull(property.getValue()).toString());
                Object object = OneShotMergeInfoHelper.this.myMergeInfoLock;
                synchronized (object) {
                    OneShotMergeInfoHelper.this.myMergeInfoMap.put(OneShotMergeInfoHelper.toKey(workingCopyRelativePath), mergeInfo);
                }
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
            }
        };
    }

    @NotNull
    private String getWorkingCopyRelativePath(@NotNull File file) {
        return FileUtil.toSystemIndependentName((String)Objects.requireNonNull(FileUtil.getRelativePath((File)this.myMergeContext.getWcInfo().getRootInfo().getIoFile(), (File)file)));
    }

    @NotNull
    private static String toKey(@NotNull String path) {
        return SystemInfo.isFileSystemCaseSensitive ? path : StringUtil.toUpperCase((String)path);
    }

    public boolean checkListForPaths(@NotNull LogHierarchyNode node) {
        boolean isLocalChange = ContainerUtil.or(node.getChildren(), this::checkForSubtree);
        return isLocalChange || OneShotMergeInfoHelper.checkForEntry(node.getMe(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath(), this.myMergeContext.getRepositoryRelativeSourcePath());
    }

    private boolean checkForSubtree(@NotNull LogHierarchyNode tree) {
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (OneShotMergeInfoHelper.checkForEntry(element.getMe(), this.myMergeContext.getRepositoryRelativeSourcePath(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath())) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (Url.isAncestor(localURL, path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !Url.isAncestor(relativeBranch, path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, MergeRangeList>> {
        @NotNull
        private final String myRepositoryRelativeSourcePath;
        private boolean myIsMerged;
        @NotNull
        private final String mySourceRelativePath;
        private final long myRevisionNumber;

        InfoProcessor(@NotNull String sourceRelativePath, @NotNull String repositoryRelativeSourcePath, long revisionNumber) {
            this.mySourceRelativePath = sourceRelativePath;
            this.myRevisionNumber = revisionNumber;
            this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(repositoryRelativeSourcePath);
        }

        public boolean isMerged() {
            return this.myIsMerged;
        }

        public boolean process(@NotNull String workingCopyRelativePath, @NotNull Map<String, MergeRangeList> mergedPathsMap) {
            boolean processed = false;
            boolean isCurrentPath = workingCopyRelativePath.equals(this.mySourceRelativePath);
            if (mergedPathsMap.isEmpty()) {
                this.myIsMerged = false;
                processed = true;
            } else {
                String mergedPathAffectingSourcePath = (String)ContainerUtil.find(mergedPathsMap.keySet(), path -> Url.isAncestor(this.myRepositoryRelativeSourcePath, SvnUtil.ensureStartSlash(path)));
                if (mergedPathAffectingSourcePath != null) {
                    MergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingSourcePath);
                    processed = true;
                    this.myIsMerged = ContainerUtil.exists(mergeRangeList.getRanges(), range -> range.contains(this.myRevisionNumber) && (range.isInheritable() || isCurrentPath));
                }
            }
            return processed;
        }
    }
}

