/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;

    public QuickMergeInteractionImpl(@NotNull MergeContext mergeContext) {
        this.myMergeContext = mergeContext;
        this.myProject = mergeContext.getProject();
        this.myTitle = mergeContext.getTitle();
    }

    @Override
    @NotNull
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.title("Select Merge Variant").centerPanel((JComponent)panel.getMainPanel()).removeAllActions();
        panel.setWrapper(builder.getDialogWrapper());
        builder.show();
        return panel.getVariant();
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt("There are some switched paths in the working copy. Do you want to continue?");
    }

    @Override
    public boolean shouldReintegrate(@NotNull Url targetUrl) {
        return this.prompt("<html><body>You are going to reintegrate changes.<br><br>This will make branch '" + this.myMergeContext.getSourceUrl().toDecodedString() + "' <b>no longer usable for further work</b>.<br>It will not be able to correctly absorb new trunk (" + targetUrl.toDecodedString() + ") changes,<br>nor can this branch be properly reintegrated to trunk again.<br><br>Are you sure?</body></html>");
    }

    @Override
    @NotNull
    public SelectMergeItemsResult selectMergeItems(@NotNull List<SvnChangeList> lists, @NotNull MergeChecker mergeChecker, boolean allStatusesCalculated, boolean allListsLoaded) {
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, lists, this.myMergeContext.getTitle(), mergeChecker, allStatusesCalculated, allListsLoaded);
        dialog.show();
        QuickMergeContentsVariants resultCode = QuickMergeInteractionImpl.toMergeVariant(dialog.getExitCode());
        List<SvnChangeList> selectedLists = resultCode == QuickMergeContentsVariants.select ? dialog.getSelected() : ContainerUtil.emptyList();
        return new SelectMergeItemsResult(resultCode, selectedLists);
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        String message;
        LocalChangesAction[] possibleResults;
        if (!mergeAll) {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that will intersect with merge changes.\nDo you want to continue?";
        } else {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that can potentially intersect with merge changes.\nDo you want to continue?";
        }
        int result = Messages.showDialog((String)message, (String)this.myTitle, (String[])((String[])ContainerUtil.map2Array((Object[])possibleResults, String.class, (Function)Functions.TO_STRING())), (int)0, (Icon)Messages.getQuestionIcon());
        return result == -1 ? LocalChangesAction.cancel : possibleResults[result];
    }

    @Override
    public void showIntersectedLocalPaths(@NotNull List<FilePath> paths) {
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, this.myTitle + ", local changes intersection", paths, "The following file(s) have local changes that will intersect with merge changes:");
    }

    @Override
    public void showErrors(@NotNull String message, @NotNull List<VcsException> exceptions) {
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(@NotNull String message, boolean isError) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    private boolean prompt(@NotNull String question) {
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myTitle, (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static QuickMergeContentsVariants toMergeVariant(int exitCode) {
        switch (exitCode) {
            case 222: {
                return QuickMergeContentsVariants.all;
            }
            case 0: {
                return QuickMergeContentsVariants.select;
            }
        }
        return QuickMergeContentsVariants.cancel;
    }
}

