/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.LogEntryPath;

public final class LogEntry {
    public static final LogEntry EMPTY = new Builder().setRevision(-1L).setHasChildren(false).build();
    private final long myRevision;
    @Nullable
    private final Date myDate;
    private final String myMessage;
    private final String myAuthor;
    @NotNull
    private final Map<String, LogEntryPath> myChangedPaths;
    private final boolean myHasChildren;

    public LogEntry(@NotNull Builder builder) {
        this.myRevision = builder.revision;
        this.myChangedPaths = LogEntry.toImmutable(builder.changedPaths);
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myMessage = builder.message;
        this.myHasChildren = builder.hasChildren();
    }

    @NotNull
    private static Map<String, LogEntryPath> toImmutable(@NotNull List<LogEntryPath.Builder> paths) {
        HashMap<String, LogEntryPath> result = new HashMap<String, LogEntryPath>();
        for (LogEntryPath.Builder path : paths) {
            result.put(path.getPath(), path.build());
        }
        return Collections.unmodifiableMap(result);
    }

    @NotNull
    public Map<String, LogEntryPath> getChangedPaths() {
        return this.myChangedPaths;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public Date getDate() {
        return this.myDate;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentry")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        @XmlElement(name="msg")
        private String message;
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        private final List<LogEntryPath.Builder> changedPaths = new ArrayList<LogEntryPath.Builder>();
        @XmlElement(name="logentry")
        private final List<Builder> childEntries = new ArrayList<Builder>();

        @NotNull
        public List<Builder> getChildEntries() {
            return this.childEntries;
        }

        public boolean hasChildren() {
            return !this.childEntries.isEmpty();
        }

        @NotNull
        public Builder setRevision(long revision) {
            this.revision = revision;
            return this;
        }

        @NotNull
        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        @NotNull
        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        @NotNull
        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        @NotNull
        public Builder setHasChildren(boolean hasChildren) {
            this.childEntries.clear();
            if (hasChildren) {
                this.childEntries.add(this);
            }
            return this;
        }

        @NotNull
        public Builder addPath(@NotNull LogEntryPath.Builder path) {
            this.changedPaths.add(path);
            return this;
        }

        @NotNull
        public LogEntry build() {
            return new LogEntry(this);
        }
    }
}

