/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.api.InfoCommandRepositoryProvider;
import org.jetbrains.idea.svn.api.Repository;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.api.UrlMappingRepositoryProvider;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.CommandUtil;

public class CommandParametersResolutionModule
extends BaseCommandRuntimeModule {
    public CommandParametersResolutionModule(@NotNull CommandRuntime runtime) {
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (command.getRepositoryUrl() == null) {
            command.setRepositoryUrl(this.resolveRepositoryUrl(command));
        }
        if (command.getWorkingDirectory() == null) {
            command.setWorkingDirectory(this.resolveWorkingDirectory(command));
        }
        command.setConfigDir(this.myAuthenticationService.getSpecialConfigDir().toFile());
        command.saveOriginalParameters();
    }

    @Nullable
    private Url resolveRepositoryUrl(@NotNull Command command) {
        UrlMappingRepositoryProvider urlMappingProvider = new UrlMappingRepositoryProvider(this.myVcs, command.getTarget());
        InfoCommandRepositoryProvider infoCommandProvider = new InfoCommandRepositoryProvider(this.myVcs, command.getTarget());
        Repository repository = urlMappingProvider.get();
        if (repository == null && !command.isLocalInfo()) {
            repository = infoCommandProvider.get();
        }
        return repository != null ? repository.getUrl() : null;
    }

    @NotNull
    private File resolveWorkingDirectory(@NotNull Command command) {
        File file = command.getTarget().getFile();
        RootUrlInfo root = file != null ? this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((File)file)) : null;
        return root != null ? root.getIoFile() : CommandParametersResolutionModule.getDefaultWorkingDirectory(this.myVcs.getProject());
    }

    @NotNull
    public static File getDefaultWorkingDirectory(@NotNull Project project) {
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null ? VfsUtilCore.virtualToIoFile((VirtualFile)baseDir) : CommandUtil.getHomeDirectory();
    }
}

