/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;

public class SelectBranchPopup {
    private SelectBranchPopup() {
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        SelectBranchPopup.show(project, file, callback, title, null);
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        RootUrlInfo rootUrlInfo;
        SvnFileUrlMapping urlMapping = SvnVcs.getInstance(project).getSvnFileUrlMapping();
        Url svnurl = urlMapping.getUrlForFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (svnurl != null && (rootUrlInfo = urlMapping.getWcRootForUrl(svnurl)) != null) {
            SelectBranchPopup.showForBranchRoot(project, rootUrlInfo.getVirtualFile(), callback, title, component);
        }
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        SelectBranchPopup.showForBranchRoot(project, vcsRoot, callback, title, null);
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        ArrayList<Object> items = new ArrayList<Object>();
        ContainerUtil.addIfNotNull(items, (Object)configuration.getTrunk());
        items.addAll(configuration.getBranchLocations());
        items.add(SelectBranchPopup.getConfigureMessage());
        BranchBasesPopupStep step = new BranchBasesPopupStep(project, vcsRoot, configuration, callback, items, title, component);
        step.showPopupAt((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    @NotNull
    private static String getBranchName(@NotNull SvnBranchItem branch) {
        return branch.getUrl().getTail();
    }

    private static String getConfigureMessage() {
        return SvnBundle.message("configure.branches.item", new Object[0]);
    }

    private static class BranchRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        private final JLabel myUrlLabel = new JLabel();
        private final JLabel myDateLabel = new JLabel();

        BranchRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myUrlLabel, "West");
            this.add((Component)this.myDateLabel, "East");
            this.myUrlLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setHorizontalAlignment(4);
            this.myDateLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(UIUtil.getListSelectionBackground((boolean)true));
                Color selectedForegroundColor = UIUtil.getListSelectionForeground();
                this.myUrlLabel.setForeground(selectedForegroundColor);
                this.myDateLabel.setForeground(selectedForegroundColor);
                this.setForeground(selectedForegroundColor);
            } else {
                this.setBackground(UIUtil.getListBackground());
                Color foregroundColor = UIUtil.getListForeground();
                this.myUrlLabel.setForeground(foregroundColor);
                this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
                this.setForeground(foregroundColor);
            }
            if (value instanceof String) {
                this.myUrlLabel.setText((String)value);
                this.myDateLabel.setText("");
            } else {
                SvnBranchItem item = (SvnBranchItem)value;
                this.myUrlLabel.setText(SelectBranchPopup.getBranchName(item));
                long creationMillis = item.getCreationDateMillis();
                this.myDateLabel.setText(creationMillis > 0L ? DateFormatUtil.formatDate((long)creationMillis) : "");
            }
            return this;
        }
    }

    private static class BranchBasesPopupStep
    extends BaseListPopupStep<Object> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myVcsRoot;
        @NotNull
        private final SvnBranchConfigurationNew myConfiguration;
        @NotNull
        private final BranchSelectedCallback myCallback;
        @Nullable
        private final Component myComponent;

        BranchBasesPopupStep(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull SvnBranchConfigurationNew configuration, @NotNull BranchSelectedCallback callback, @NotNull List<Object> items, @Nullable String title, @Nullable Component component) {
            this.myProject = project;
            this.myVcsRoot = vcsRoot;
            this.myConfiguration = configuration;
            this.myCallback = callback;
            this.myComponent = component;
            this.init(title, items, null);
        }

        public ListSeparator getSeparatorAbove(Object value) {
            return SelectBranchPopup.getConfigureMessage().equals(value) ? new ListSeparator("") : null;
        }

        @NotNull
        public String getTextFor(@NotNull Object value) {
            if (value instanceof Url) {
                Url url = (Url)value;
                String suffix = url.equals(this.myConfiguration.getTrunk()) ? " (trunk)" : "...";
                return url.getTail() + suffix;
            }
            return String.valueOf(value);
        }

        public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
            if (SelectBranchPopup.getConfigureMessage().equals(selectedValue)) {
                return this.doFinalStep(() -> BranchConfigurationDialog.configureBranches(this.myProject, this.myVcsRoot));
            }
            Url url = (Url)selectedValue;
            if (url.equals(this.myConfiguration.getTrunk())) {
                return this.doFinalStep(() -> this.myCallback.branchSelected(this.myProject, this.myConfiguration, url, -1L));
            }
            return this.doFinalStep(() -> this.showBranchPopup(url));
        }

        private void loadBranches(final @NotNull Url branchLocation, final @NotNull Runnable runnable) {
            new Task.Backgroundable(this.myProject, SvnBundle.message("compare.with.branch.progress.loading.branches", new Object[0]), true){

                public void onFinished() {
                    runnable.run();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    NewRootBunch manager = SvnBranchConfigurationManager.getInstance(this.myProject).getSvnBranchConfigManager();
                    manager.reloadBranches(myVcsRoot, branchLocation, InfoReliability.setByUser, false);
                }
            }.queue();
        }

        private void showBranchPopup(@NotNull Url branchLocation) {
            List<SvnBranchItem> branches = this.myConfiguration.getBranches(branchLocation);
            ArrayList<SvnBranchItem> items = new ArrayList<SvnBranchItem>(branches);
            items.add((SvnBranchItem)((Object)BranchBasesPopupStep.getRefreshMessage()));
            JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle(branchLocation.getTail()).setRenderer((ListCellRenderer)new BranchRenderer()).setResizable(true).setItemChosenCallback(v -> {
                if (BranchBasesPopupStep.getRefreshMessage().equals(v)) {
                    this.loadBranches(branchLocation, () -> this.showBranchPopup(branchLocation));
                    return;
                }
                SvnBranchItem item = (SvnBranchItem)v;
                if (item != null) {
                    this.myCallback.branchSelected(this.myProject, this.myConfiguration, item.getUrl(), item.getRevision());
                }
            }).setNamerForFiltering(item -> item instanceof SvnBranchItem ? SelectBranchPopup.getBranchName((SvnBranchItem)item) : null).createPopup();
            this.showPopupAt(popup);
        }

        public void showPopupAt(@NotNull JBPopup listPopup) {
            if (this.myComponent == null) {
                listPopup.showCenteredInCurrentWindow(this.myProject);
            } else {
                listPopup.showInCenterOf(this.myComponent);
            }
        }

        private static String getRefreshMessage() {
            return SvnBundle.message("refresh.branches.item", new Object[0]);
        }
    }

    public static interface BranchSelectedCallback {
        public void branchSelected(Project var1, SvnBranchConfigurationNew var2, @NotNull Url var3, long var4);
    }
}

